/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.ConfigurationUtil;
import io.camunda.zeebe.broker.system.configuration.DiskCfg;
import io.camunda.zeebe.broker.system.configuration.backup.BackupStoreCfg;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.util.unit.DataSize;

public final class DataCfg
implements ConfigurationEntry {
    public static final String DEFAULT_DIRECTORY = "data";
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private static final DataSize DEFAULT_DATA_SIZE = DataSize.ofMegabytes((long)128L);
    private String directory = "data";
    private String runtimeDirectory = null;
    private DataSize logSegmentSize = DEFAULT_DATA_SIZE;
    private Duration snapshotPeriod = Duration.ofMinutes(5L);
    private int logIndexDensity = 100;
    private Boolean diskUsageMonitoringEnabled;
    private Double diskUsageReplicationWatermark;
    private Double diskUsageCommandWatermark;
    private Duration diskUsageMonitoringInterval;
    private DiskCfg disk = new DiskCfg();
    private BackupStoreCfg backup = new BackupStoreCfg();

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.directory = ConfigurationUtil.toAbsolutePath(this.directory, brokerBase);
        if (this.runtimeDirectory != null) {
            this.runtimeDirectory = ConfigurationUtil.toAbsolutePath(this.runtimeDirectory, brokerBase);
        }
        this.backup.init(globalConfig, brokerBase);
        this.overrideDiskConfig();
        this.disk.init(globalConfig, brokerBase);
    }

    private void overrideDiskConfig() {
        DataSize requiredFreeSpace;
        if (this.diskUsageMonitoringEnabled != null) {
            LOG.warn("Configuration parameter data.diskUsageMonitoringEnabled is deprecated. Use data.disk.enableMonitoring instead.");
            this.disk.setEnableMonitoring(this.diskUsageMonitoringEnabled);
        }
        if (this.diskUsageMonitoringInterval != null) {
            LOG.warn("Configuration parameter data.diskUsageMonitoringInterval is deprecated. Use data.disk.monitoringInterval instead.");
            this.disk.setMonitoringInterval(this.diskUsageMonitoringInterval);
        }
        if (this.diskUsageCommandWatermark != null) {
            LOG.warn("Configuration parameter data.diskUsageCommandWatermark is deprecated. Use data.disk.freeSpace.processing instead.");
            requiredFreeSpace = this.convertWatermarkToFreeSpace(this.diskUsageCommandWatermark);
            this.disk.getFreeSpace().setProcessing(requiredFreeSpace);
        }
        if (this.diskUsageReplicationWatermark != null) {
            LOG.warn("Configuration parameter data.diskUsageReplicationWatermark is deprecated. Use data.disk.freeSpace.replication instead.");
            requiredFreeSpace = this.convertWatermarkToFreeSpace(this.diskUsageReplicationWatermark);
            this.disk.getFreeSpace().setReplication(requiredFreeSpace);
        }
    }

    private DataSize convertWatermarkToFreeSpace(Double watermark) {
        File directoryFile = new File(this.getDirectory());
        return DataSize.ofBytes((long)Math.round((double)directoryFile.getTotalSpace() * (1.0 - watermark)));
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getRuntimeDirectory() {
        return this.runtimeDirectory;
    }

    public void setRuntimeDirectory(String runtimeDirectory) {
        this.runtimeDirectory = runtimeDirectory;
    }

    public boolean useSeparateRuntimeDirectory() {
        return this.runtimeDirectory != null && !this.runtimeDirectory.isEmpty();
    }

    public long getLogSegmentSizeInBytes() {
        return Optional.ofNullable(this.logSegmentSize).orElse(DEFAULT_DATA_SIZE).toBytes();
    }

    public DataSize getLogSegmentSize() {
        return this.logSegmentSize;
    }

    public void setLogSegmentSize(DataSize logSegmentSize) {
        this.logSegmentSize = logSegmentSize;
    }

    public Duration getSnapshotPeriod() {
        return this.snapshotPeriod;
    }

    public void setSnapshotPeriod(Duration snapshotPeriod) {
        this.snapshotPeriod = snapshotPeriod;
    }

    public int getLogIndexDensity() {
        return this.logIndexDensity;
    }

    public void setLogIndexDensity(int logIndexDensity) {
        this.logIndexDensity = logIndexDensity;
    }

    public void setDiskUsageMonitoringEnabled(boolean diskUsageMonitoringEnabled) {
        this.diskUsageMonitoringEnabled = diskUsageMonitoringEnabled;
    }

    public void setDiskUsageCommandWatermark(double diskUsageCommandWatermark) {
        this.diskUsageCommandWatermark = diskUsageCommandWatermark;
    }

    public void setDiskUsageReplicationWatermark(double diskUsageReplicationWatermark) {
        this.diskUsageReplicationWatermark = diskUsageReplicationWatermark;
    }

    public void setDiskUsageMonitoringInterval(Duration diskUsageMonitoringInterval) {
        this.diskUsageMonitoringInterval = diskUsageMonitoringInterval;
    }

    public DiskCfg getDisk() {
        return this.disk;
    }

    public void setDisk(DiskCfg disk) {
        this.disk = disk;
    }

    public BackupStoreCfg getBackup() {
        return this.backup;
    }

    public void setBackup(BackupStoreCfg backup) {
        this.backup = backup;
    }

    public String toString() {
        return "DataCfg{directory='" + this.directory + "', stateDirectory='" + this.runtimeDirectory + "', logSegmentSize=" + String.valueOf(this.logSegmentSize) + ", snapshotPeriod=" + String.valueOf(this.snapshotPeriod) + ", logIndexDensity=" + this.logIndexDensity + ", diskUsageMonitoringEnabled=" + this.diskUsageMonitoringEnabled + ", diskUsageReplicationWatermark=" + this.diskUsageReplicationWatermark + ", diskUsageCommandWatermark=" + this.diskUsageCommandWatermark + ", diskUsageMonitoringInterval=" + String.valueOf(this.diskUsageMonitoringInterval) + ", disk=" + String.valueOf(this.disk) + ", backup=" + String.valueOf(this.backup) + "}";
    }
}

