/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.exporter.debug.DebugLogExporter;
import io.camunda.zeebe.broker.exporter.metrics.MetricsExporter;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.configuration.EmbeddedGatewayCfg;
import io.camunda.zeebe.broker.system.configuration.ExperimentalCfg;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.broker.system.configuration.ExportingCfg;
import io.camunda.zeebe.broker.system.configuration.FlowControlCfg;
import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import io.camunda.zeebe.broker.system.configuration.ProcessingCfg;
import io.camunda.zeebe.broker.system.configuration.ThreadsCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.LimitCfg;
import io.camunda.zeebe.util.Environment;
import java.util.HashMap;
import java.util.Map;

public class BrokerCfg {
    static final String ENV_DEBUG_EXPORTER = "ZEEBE_DEBUG";
    private NetworkCfg network = new NetworkCfg();
    private ClusterCfg cluster = new ClusterCfg();
    private ThreadsCfg threads = new ThreadsCfg();
    private DataCfg data = new DataCfg();
    private Map<String, ExporterCfg> exporters = new HashMap<String, ExporterCfg>();
    private ExportingCfg exporting = new ExportingCfg();
    private EmbeddedGatewayCfg gateway = new EmbeddedGatewayCfg();
    private FlowControlCfg flowControl = new FlowControlCfg();
    private LimitCfg backpressure = new LimitCfg();
    private ProcessingCfg processingCfg = new ProcessingCfg();
    private ExperimentalCfg experimental = new ExperimentalCfg();
    private boolean executionMetricsExporterEnabled;

    public void init(String brokerBase) {
        this.init(brokerBase, new Environment());
    }

    public void init(String brokerBase, Environment environment) {
        this.applyEnvironment(environment);
        if (this.isExecutionMetricsExporterEnabled()) {
            this.exporters.put(MetricsExporter.defaultExporterId(), MetricsExporter.defaultConfig());
        }
        this.network.init(this, brokerBase);
        this.cluster.init(this, brokerBase);
        this.threads.init(this, brokerBase);
        this.data.init(this, brokerBase);
        this.exporters.values().forEach(e -> e.init(this, brokerBase));
        this.gateway.init(this, brokerBase);
        this.flowControl.init(this, brokerBase);
        this.backpressure.init(this, brokerBase);
        this.processingCfg.init(this, brokerBase);
        this.experimental.init(this, brokerBase);
    }

    private void applyEnvironment(Environment environment) {
        if (environment.getBool(ENV_DEBUG_EXPORTER).orElse(false).booleanValue()) {
            this.exporters.put(DebugLogExporter.defaultExporterId(), DebugLogExporter.defaultConfig());
        }
    }

    public NetworkCfg getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkCfg network) {
        this.network = network;
    }

    public ClusterCfg getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterCfg cluster) {
        this.cluster = cluster;
    }

    public ThreadsCfg getThreads() {
        return this.threads;
    }

    public void setThreads(ThreadsCfg threads) {
        this.threads = threads;
    }

    public DataCfg getData() {
        return this.data;
    }

    public void setData(DataCfg logs) {
        this.data = logs;
    }

    public Map<String, ExporterCfg> getExporters() {
        return this.exporters;
    }

    public void setExporters(Map<String, ExporterCfg> exporters) {
        this.exporters = exporters;
    }

    public ExportingCfg getExporting() {
        return this.exporting;
    }

    public void setExporting(ExportingCfg exporting) {
        this.exporting = exporting;
    }

    public EmbeddedGatewayCfg getGateway() {
        return this.gateway;
    }

    public BrokerCfg setGateway(EmbeddedGatewayCfg gateway) {
        this.gateway = gateway;
        return this;
    }

    public FlowControlCfg getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(FlowControlCfg flowControl) {
        this.flowControl = flowControl;
    }

    public LimitCfg getBackpressure() {
        return this.backpressure;
    }

    public BrokerCfg setBackpressure(LimitCfg backpressure) {
        this.backpressure = backpressure;
        return this;
    }

    public boolean isExecutionMetricsExporterEnabled() {
        return this.executionMetricsExporterEnabled;
    }

    public void setExecutionMetricsExporterEnabled(boolean executionMetricsExporterEnabled) {
        this.executionMetricsExporterEnabled = executionMetricsExporterEnabled;
    }

    public ProcessingCfg getProcessing() {
        return this.processingCfg;
    }

    public void setProcessingCfg(ProcessingCfg cfg) {
        this.processingCfg = cfg;
    }

    public ExperimentalCfg getExperimental() {
        return this.experimental;
    }

    public void setExperimental(ExperimentalCfg experimental) {
        this.experimental = experimental;
    }

    public String toString() {
        return "BrokerCfg{network=" + String.valueOf(this.network) + ", cluster=" + String.valueOf(this.cluster) + ", threads=" + String.valueOf(this.threads) + ", data=" + String.valueOf(this.data) + ", exporters=" + String.valueOf(this.exporters) + ", exporting=" + String.valueOf(this.exporting) + ", gateway=" + String.valueOf(this.gateway) + ", flowControl=" + String.valueOf(this.flowControl) + ", backpressure=" + String.valueOf(this.backpressure) + ", processingCfg=" + String.valueOf(this.processingCfg) + ", experimental=" + String.valueOf(this.experimental) + ", executionMetricsExporterEnabled=" + this.executionMetricsExporterEnabled + "}";
    }
}

