/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.protocol;

import io.camunda.zeebe.broker.protocol.InterPartitionMessageDecoder;
import io.camunda.zeebe.broker.protocol.MessageHeaderEncoder;
import io.camunda.zeebe.broker.protocol.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class InterPartitionMessageEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 4;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final InterPartitionMessageEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 4;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public InterPartitionMessageEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 20);
        return this;
    }

    public InterPartitionMessageEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(20).templateId(4).schemaId(5).version(3);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int receiverPartitionIdId() {
        return 0;
    }

    public static int receiverPartitionIdSinceVersion() {
        return 0;
    }

    public static int receiverPartitionIdEncodingOffset() {
        return 0;
    }

    public static int receiverPartitionIdEncodingLength() {
        return 2;
    }

    public static String receiverPartitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int receiverPartitionIdNullValue() {
        return 65535;
    }

    public static int receiverPartitionIdMinValue() {
        return 0;
    }

    public static int receiverPartitionIdMaxValue() {
        return 65534;
    }

    public InterPartitionMessageEncoder receiverPartitionId(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, BYTE_ORDER);
        return this;
    }

    public static int valueTypeId() {
        return 1;
    }

    public static int valueTypeSinceVersion() {
        return 0;
    }

    public static int valueTypeEncodingOffset() {
        return 2;
    }

    public static int valueTypeEncodingLength() {
        return 1;
    }

    public static String valueTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short valueTypeNullValue() {
        return 255;
    }

    public static short valueTypeMinValue() {
        return 0;
    }

    public static short valueTypeMaxValue() {
        return 254;
    }

    public InterPartitionMessageEncoder valueType(short value) {
        this.buffer.putByte(this.offset + 2, (byte)value);
        return this;
    }

    public static int intentId() {
        return 2;
    }

    public static int intentSinceVersion() {
        return 0;
    }

    public static int intentEncodingOffset() {
        return 3;
    }

    public static int intentEncodingLength() {
        return 1;
    }

    public static String intentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short intentNullValue() {
        return 255;
    }

    public static short intentMinValue() {
        return 0;
    }

    public static short intentMaxValue() {
        return 254;
    }

    public InterPartitionMessageEncoder intent(short value) {
        this.buffer.putByte(this.offset + 3, (byte)value);
        return this;
    }

    public static int recordKeyId() {
        return 3;
    }

    public static int recordKeySinceVersion() {
        return 0;
    }

    public static int recordKeyEncodingOffset() {
        return 4;
    }

    public static int recordKeyEncodingLength() {
        return 8;
    }

    public static String recordKeyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long recordKeyNullValue() {
        return -1L;
    }

    public static long recordKeyMinValue() {
        return 0L;
    }

    public static long recordKeyMaxValue() {
        return -2L;
    }

    public InterPartitionMessageEncoder recordKey(long value) {
        this.buffer.putLong(this.offset + 4, value, BYTE_ORDER);
        return this;
    }

    public static int checkpointIdId() {
        return 4;
    }

    public static int checkpointIdSinceVersion() {
        return 0;
    }

    public static int checkpointIdEncodingOffset() {
        return 12;
    }

    public static int checkpointIdEncodingLength() {
        return 8;
    }

    public static String checkpointIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long checkpointIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long checkpointIdMinValue() {
        return -9223372036854775807L;
    }

    public static long checkpointIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public InterPartitionMessageEncoder checkpointId(long value) {
        this.buffer.putLong(this.offset + 12, value, BYTE_ORDER);
        return this;
    }

    public static int commandId() {
        return 32;
    }

    public static String commandCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String commandMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int commandHeaderLength() {
        return 4;
    }

    public InterPartitionMessageEncoder putCommand(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public InterPartitionMessageEncoder putCommand(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public InterPartitionMessageEncoder command(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        InterPartitionMessageDecoder decoder = new InterPartitionMessageDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 20, 3);
        return decoder.appendTo(builder);
    }
}

