/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.protocol;

import io.camunda.zeebe.broker.protocol.ExporterStateDecoder;
import io.camunda.zeebe.broker.protocol.MessageHeaderEncoder;
import io.camunda.zeebe.broker.protocol.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class ExporterStateEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ExporterStateEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private final StateEncoder state = new StateEncoder(this);

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ExporterStateEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 0);
        return this;
    }

    public ExporterStateEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(0).templateId(1).schemaId(5).version(3);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long stateId() {
        return 0L;
    }

    public StateEncoder stateCount(int count) {
        this.state.wrap(this.buffer, count);
        return this.state;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ExporterStateDecoder decoder = new ExporterStateDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 0, 3);
        return decoder.appendTo(builder);
    }

    public static final class StateEncoder {
        public static final int HEADER_SIZE = 3;
        private final ExporterStateEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        StateEncoder(ExporterStateEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)8, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public StateEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + StateEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public static int positionId() {
            return 0;
        }

        public static int positionSinceVersion() {
            return 0;
        }

        public static int positionEncodingOffset() {
            return 0;
        }

        public static int positionEncodingLength() {
            return 8;
        }

        public static String positionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
                return "long";
            }
            return "";
        }

        public static long positionNullValue() {
            return -1L;
        }

        public static long positionMinValue() {
            return 0L;
        }

        public static long positionMaxValue() {
            return -2L;
        }

        public StateEncoder position(long value) {
            this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
            return this;
        }

        public static int exporterIdId() {
            return 1;
        }

        public static String exporterIdCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String exporterIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
                return "string";
            }
            return "";
        }

        public static int exporterIdHeaderLength() {
            return 4;
        }

        public StateEncoder putExporterId(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public StateEncoder putExporterId(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public StateEncoder exporterId(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }

        public static int metadataId() {
            return 2;
        }

        public static String metadataCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String metadataMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            if (MetaAttribute.SEMANTIC_TYPE == metaAttribute) {
                return "binary";
            }
            return "";
        }

        public static int metadataHeaderLength() {
            return 4;
        }

        public StateEncoder putMetadata(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public StateEncoder putMetadata(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public StateEncoder metadata(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }
}

