/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.topology;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributor;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributorBuilder;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.PartitioningCfg;
import io.camunda.zeebe.broker.system.configuration.partitioning.FixedPartitionCfg;
import io.camunda.zeebe.broker.system.configuration.partitioning.Scheme;
import io.camunda.zeebe.dynamic.config.PartitionDistributor;
import io.camunda.zeebe.dynamic.config.StaticConfiguration;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.dynamic.config.state.ExporterState;
import io.camunda.zeebe.dynamic.config.state.ExportersConfig;
import io.camunda.zeebe.dynamic.config.util.RoundRobinPartitionDistributor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class StaticConfigurationGenerator {
    private StaticConfigurationGenerator() {
    }

    public static StaticConfiguration getStaticConfiguration(BrokerCfg brokerCfg, MemberId localMemberId) {
        ClusterCfg clusterCfg = brokerCfg.getCluster();
        boolean enablePartitionScaling = brokerCfg.getExperimental().getFeatures().isEnablePartitionScaling();
        PartitioningCfg partitioningCfg = brokerCfg.getExperimental().getPartitioning();
        int partitionCount = clusterCfg.getPartitionsCount();
        int replicationFactor = clusterCfg.getReplicationFactor();
        PartitionDistributor partitionDistributor = StaticConfigurationGenerator.getPartitionDistributor(partitioningCfg);
        Set<MemberId> clusterMembers = StaticConfigurationGenerator.getRaftGroupMembers(clusterCfg);
        List<PartitionId> partitionIds = StaticConfigurationGenerator.getSortedPartitionIds(partitionCount);
        DynamicPartitionConfig partitionConfig = StaticConfigurationGenerator.generatePartitionConfig(brokerCfg);
        return new StaticConfiguration(enablePartitionScaling, partitionDistributor, clusterMembers, localMemberId, partitionIds, replicationFactor, partitionConfig);
    }

    private static PartitionDistributor getPartitionDistributor(PartitioningCfg partitionCfg) {
        return StaticConfigurationGenerator.buildPartitionDistributor(partitionCfg);
    }

    private static PartitionDistributor buildPartitionDistributor(PartitioningCfg config) {
        return config.getScheme() == Scheme.FIXED ? StaticConfigurationGenerator.buildFixedPartitionDistributor(config) : new RoundRobinPartitionDistributor();
    }

    private static FixedPartitionDistributor buildFixedPartitionDistributor(PartitioningCfg config) {
        FixedPartitionDistributorBuilder distributionBuilder = new FixedPartitionDistributorBuilder("raft-partition");
        for (FixedPartitionCfg partition : config.getFixed()) {
            for (FixedPartitionCfg.NodeCfg node : partition.getNodes()) {
                distributionBuilder.assignMember(partition.getPartitionId(), node.getNodeId(), node.getPriority());
            }
        }
        return distributionBuilder.build();
    }

    private static Set<MemberId> getRaftGroupMembers(ClusterCfg clusterCfg) {
        int clusterSize = clusterCfg.getClusterSize();
        return IntStream.range(0, clusterSize).mapToObj(nodeId -> MemberId.from((String)Integer.toString(nodeId))).collect(Collectors.toSet());
    }

    private static List<PartitionId> getSortedPartitionIds(int partitionCount) {
        return IntStream.rangeClosed(1, partitionCount).mapToObj(p -> PartitionId.from((String)"raft-partition", (int)p)).sorted().toList();
    }

    private static DynamicPartitionConfig generatePartitionConfig(BrokerCfg brokerCfg) {
        HashMap exporters = new HashMap();
        brokerCfg.getExporters().forEach((exporterId, ignore) -> exporters.put(exporterId, new ExporterState(0L, ExporterState.State.ENABLED, Optional.empty())));
        return new DynamicPartitionConfig(new ExportersConfig(Map.copyOf(exporters)));
    }
}

