/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.topology;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.partitioning.topology.ClusterConfigurationService;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistribution;
import io.camunda.zeebe.broker.partitioning.topology.StaticConfigurationGenerator;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.dynamic.config.ClusterConfigurationManager;
import io.camunda.zeebe.dynamic.config.ClusterConfigurationManagerService;
import io.camunda.zeebe.dynamic.config.ClusterConfigurationUpdateNotifier;
import io.camunda.zeebe.dynamic.config.StaticConfiguration;
import io.camunda.zeebe.dynamic.config.changes.PartitionChangeExecutor;
import io.camunda.zeebe.dynamic.config.gossip.ClusterConfigurationGossiperConfig;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.util.ConfigurationUtil;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import java.nio.file.Path;
import java.time.Duration;

public class DynamicClusterConfigurationService
implements ClusterConfigurationService {
    private PartitionDistribution partitionDistribution;
    private ClusterConfiguration initialClusterConfiguration;
    private ClusterConfigurationManagerService clusterConfigurationManagerService;

    @Override
    public PartitionDistribution getPartitionDistribution() {
        return this.partitionDistribution;
    }

    @Override
    public void registerPartitionChangeExecutor(PartitionChangeExecutor executor) {
        if (this.clusterConfigurationManagerService == null) {
            throw new IllegalStateException("Cannot register partition change executor before the topology manager is started");
        }
        this.clusterConfigurationManagerService.registerPartitionChangeExecutor(executor);
    }

    @Override
    public void removePartitionChangeExecutor() {
        if (this.clusterConfigurationManagerService != null) {
            this.clusterConfigurationManagerService.removePartitionChangeExecutor();
        }
    }

    @Override
    public ActorFuture<Void> start(BrokerStartupContext brokerStartupContext) {
        CompletableActorFuture started = new CompletableActorFuture();
        this.clusterConfigurationManagerService = this.getClusterTopologyManagerService(brokerStartupContext);
        ActorFuture<Void> topologyManagerStartedFuture = DynamicClusterConfigurationService.startClusterTopologyManager(brokerStartupContext, this.clusterConfigurationManagerService);
        topologyManagerStartedFuture.onComplete((ignore, topologyManagerFailed) -> {
            if (topologyManagerFailed != null) {
                started.completeExceptionally(topologyManagerFailed);
            } else {
                this.clusterConfigurationManagerService.addUpdateListener((ClusterConfigurationUpdateNotifier.ClusterConfigurationUpdateListener)brokerStartupContext.getBrokerClient().getTopologyManager());
                this.clusterConfigurationManagerService.getClusterTopology().onComplete((configuration, error) -> {
                    if (error != null) {
                        started.completeExceptionally(error);
                    } else {
                        try {
                            this.partitionDistribution = new PartitionDistribution(ConfigurationUtil.getPartitionDistributionFrom((ClusterConfiguration)configuration, (String)"raft-partition"));
                            this.initialClusterConfiguration = configuration;
                            started.complete(null);
                        }
                        catch (Exception topologyConversionFailed) {
                            started.completeExceptionally((Throwable)topologyConversionFailed);
                        }
                    }
                });
            }
        });
        return started;
    }

    @Override
    public void registerInconsistentConfigurationListener(ClusterConfigurationManager.InconsistentConfigurationListener listener) {
        if (this.clusterConfigurationManagerService == null) {
            throw new IllegalStateException("Cannot register topology change listener before the topology manager is started");
        }
        this.clusterConfigurationManagerService.registerTopologyChangedListener(listener);
    }

    @Override
    public void removeInconsistentConfigurationListener() {
        if (this.clusterConfigurationManagerService != null) {
            this.clusterConfigurationManagerService.removeTopologyChangedListener();
        }
    }

    @Override
    public ClusterConfiguration getInitialClusterConfiguration() {
        return this.initialClusterConfiguration;
    }

    public ActorFuture<Void> closeAsync() {
        this.partitionDistribution = null;
        if (this.clusterConfigurationManagerService != null) {
            return this.clusterConfigurationManagerService.closeAsync();
        }
        return CompletableActorFuture.completed(null);
    }

    private static ActorFuture<Void> startClusterTopologyManager(BrokerStartupContext brokerStartupContext, ClusterConfigurationManagerService clusterConfigurationManagerService) {
        BrokerCfg brokerConfiguration = brokerStartupContext.getBrokerConfiguration();
        MemberId localMember = brokerStartupContext.getClusterServices().getMembershipService().getLocalMember().id();
        StaticConfiguration staticConfiguration = StaticConfigurationGenerator.getStaticConfiguration(brokerConfiguration, localMember);
        return clusterConfigurationManagerService.start(brokerStartupContext.getActorSchedulingService(), staticConfiguration);
    }

    private ClusterConfigurationManagerService getClusterTopologyManagerService(BrokerStartupContext brokerStartupContext) {
        Path rootDirectory = Path.of(brokerStartupContext.getBrokerConfiguration().getData().getDirectory(), new String[0]);
        return new ClusterConfigurationManagerService(rootDirectory, brokerStartupContext.getClusterServices().getCommunicationService(), brokerStartupContext.getClusterServices().getMembershipService(), this.getDefaultClusterConfigurationGossiperConfig(), brokerStartupContext.getBrokerConfiguration().getExperimental().getFeatures().isEnablePartitionScaling());
    }

    private ClusterConfigurationGossiperConfig getDefaultClusterConfigurationGossiperConfig() {
        return new ClusterConfigurationGossiperConfig(true, Duration.ofSeconds(10L), Duration.ofSeconds(2L), 2);
    }
}

