/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.startup.steps;

import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.partitioning.startup.PartitionStartupContext;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;

public class RaftJoinStep
implements StartupStep<PartitionStartupContext> {
    public String getName() {
        return "Joining Raft Partition";
    }

    public ActorFuture<PartitionStartupContext> startup(PartitionStartupContext context) {
        ActorFuture result = context.concurrencyControl().createFuture();
        RaftPartition partition = context.raftPartitionFactory().createRaftPartition(context.partitionMetadata(), context.partitionDirectory());
        context.raftPartition(partition);
        partition.join(context.partitionManagementService(), (ReceivableSnapshotStore)context.snapshotStore()).whenComplete((raftPartition, throwable) -> {
            if (throwable == null) {
                result.complete((Object)context);
            } else {
                result.completeExceptionally(throwable);
            }
        });
        return result;
    }

    public ActorFuture<PartitionStartupContext> shutdown(PartitionStartupContext context) {
        ActorFuture result = context.concurrencyControl().createFuture();
        RaftPartition raftPartition = context.raftPartition();
        if (raftPartition == null) {
            result.complete((Object)context);
            return result;
        }
        raftPartition.close().whenComplete((ignored, throwable) -> {
            if (throwable == null) {
                result.complete((Object)context.raftPartition(null));
            } else {
                result.completeExceptionally(throwable);
            }
        });
        return result;
    }
}

