/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.startup.steps;

import io.camunda.zeebe.broker.partitioning.startup.PartitionStartupContext;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class PartitionDirectoryStep
implements StartupStep<PartitionStartupContext> {
    public String getName() {
        return "Partition Directory";
    }

    public ActorFuture<PartitionStartupContext> startup(PartitionStartupContext context) {
        ActorFuture result = context.concurrencyControl().createFuture();
        Path dataDirectory = Paths.get(context.brokerConfig().getData().getDirectory(), new String[0]);
        Integer partitionId = (Integer)context.partitionMetadata().id().id();
        Path partitionDirectory = dataDirectory.resolve("raft-partition").resolve("partitions").resolve(partitionId.toString());
        try {
            FileUtil.ensureDirectoryExists((Path)partitionDirectory);
            result.complete((Object)context.partitionDirectory(partitionDirectory));
        }
        catch (IOException e) {
            result.completeExceptionally((Throwable)e);
        }
        return result;
    }

    public ActorFuture<PartitionStartupContext> shutdown(PartitionStartupContext context) {
        ActorFuture result = context.concurrencyControl().createFuture();
        result.complete((Object)context.partitionDirectory(null));
        return result;
    }
}

