/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.distribution;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.broker.partitioning.distribution.FixedDistributionMember;
import io.camunda.zeebe.dynamic.config.PartitionDistributor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class FixedPartitionDistributor
implements PartitionDistributor {
    private final Map<PartitionId, Set<FixedDistributionMember>> distribution;

    FixedPartitionDistributor(Map<PartitionId, Set<FixedDistributionMember>> distribution) {
        this.distribution = distribution;
    }

    public Set<PartitionMetadata> distributePartitions(Set<MemberId> clusterMembers, List<PartitionId> sortedPartitionIds, int replicationFactor) {
        HashSet<PartitionMetadata> partitions = new HashSet<PartitionMetadata>();
        for (PartitionId partitionId : sortedPartitionIds) {
            PartitionMetadata metadata = this.createPartitionMetadata(clusterMembers, replicationFactor, partitionId);
            partitions.add(metadata);
        }
        return partitions;
    }

    private PartitionMetadata createPartitionMetadata(Set<MemberId> clusterMembers, int replicationFactor, PartitionId partitionId) {
        Set<FixedDistributionMember> configuredMembers = this.distribution.get(partitionId);
        if (configuredMembers == null) {
            throw new IllegalStateException(String.format("Expected to distribute partition %d, but no members configured for it", partitionId.id()));
        }
        Map<MemberId, Integer> priorities = configuredMembers.stream().collect(Collectors.toMap(FixedDistributionMember::getId, FixedDistributionMember::getPriority));
        int targetPriority = Collections.max(priorities.values());
        Set<MemberId> members = priorities.keySet();
        List primaries = priorities.entrySet().stream().filter(entry -> (Integer)entry.getValue() == targetPriority).map(Map.Entry::getKey).collect(Collectors.toList());
        MemberId primary = null;
        if (primaries.size() == 1) {
            primary = (MemberId)primaries.get(0);
        }
        this.ensureMembersArePartOfCluster(clusterMembers, partitionId, members);
        this.ensurePartitionIsFullyReplicated(replicationFactor, partitionId, members);
        return new PartitionMetadata(partitionId, members, priorities, targetPriority, primary);
    }

    private void ensureMembersArePartOfCluster(Set<MemberId> clusterMembers, PartitionId partitionId, Set<MemberId> members) {
        if (!clusterMembers.containsAll(members)) {
            HashSet<MemberId> unknownMembers = new HashSet<MemberId>(members);
            unknownMembers.removeAll(clusterMembers);
            throw new IllegalStateException(String.format("Expected partition %d to be replicated across a cluster made of members %s, but the following configured members %s are not part of the cluster", partitionId.id(), clusterMembers, unknownMembers));
        }
    }

    private void ensurePartitionIsFullyReplicated(int replicationFactor, PartitionId partitionId, Set<MemberId> members) {
        if (members.size() != replicationFactor) {
            throw new IllegalStateException(String.format("Expected each partition to be replicated across exactly %d members, but partition %d is replicated across members %s", replicationFactor, partitionId.id(), members));
        }
    }
}

