/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.logstreams;

import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.camunda.zeebe.broker.logstreams.AtomixAppendListenerAdapter;
import io.camunda.zeebe.broker.logstreams.AtomixLogStorageReader;
import io.camunda.zeebe.broker.logstreams.AtomixReaderFactory;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class AtomixLogStorage
implements LogStorage,
RaftCommitListener {
    private final AtomixReaderFactory readerFactory;
    private final ZeebeLogAppender logAppender;
    private final Set<LogStorage.CommitListener> commitListeners = new CopyOnWriteArraySet<LogStorage.CommitListener>();

    public AtomixLogStorage(AtomixReaderFactory readerFactory, ZeebeLogAppender logAppender) {
        this.readerFactory = readerFactory;
        this.logAppender = logAppender;
    }

    public static AtomixLogStorage ofPartition(AtomixReaderFactory readerFactory, ZeebeLogAppender appender) {
        return new AtomixLogStorage(readerFactory, appender);
    }

    public AtomixLogStorageReader newReader() {
        return new AtomixLogStorageReader(this.readerFactory.create());
    }

    public void append(long lowestPosition, long highestPosition, BufferWriter bufferWriter, LogStorage.AppendListener listener) {
        AtomixAppendListenerAdapter adapter = new AtomixAppendListenerAdapter(listener);
        this.logAppender.appendEntry(lowestPosition, highestPosition, bufferWriter, (ZeebeLogAppender.AppendListener)adapter);
    }

    public void addCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.add(listener);
    }

    public void removeCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.remove(listener);
    }

    public void onCommit(long index) {
        this.commitListeners.forEach(LogStorage.CommitListener::onCommit);
    }
}

