/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.jobstream;

import io.camunda.zeebe.broker.jobstream.RemoteJobStreamErrorHandlerService;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.protocol.impl.stream.job.ActivatedJob;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.ActorFutureCollector;
import io.camunda.zeebe.transport.stream.api.RemoteStreamService;
import java.util.Objects;
import java.util.stream.Stream;

public record JobStreamService(RemoteStreamService<JobActivationProperties, ActivatedJob> remoteStreamService, JobStreamer jobStreamer, RemoteJobStreamErrorHandlerService errorHandlerService) {
    public JobStreamService(RemoteStreamService<JobActivationProperties, ActivatedJob> remoteStreamService, JobStreamer jobStreamer, RemoteJobStreamErrorHandlerService errorHandlerService) {
        this.remoteStreamService = Objects.requireNonNull(remoteStreamService, "must provide a stream remoteStreamService");
        this.jobStreamer = Objects.requireNonNull(jobStreamer, "must provide a job streamer");
        this.errorHandlerService = Objects.requireNonNull(errorHandlerService, "must provide an error handler service");
    }

    public ActorFuture<?> closeAsync(ConcurrencyControl executor) {
        return (ActorFuture)Stream.of(this.remoteStreamService.closeAsync(executor), this.errorHandlerService.closeAsync()).collect(new ActorFutureCollector(executor));
    }
}

