/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.jobstream;

import io.camunda.zeebe.transport.stream.api.RemoteStreamMetrics;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorCode;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;

public class JobStreamMetrics
implements RemoteStreamMetrics {
    private static final String NAMESPACE = "zeebe_broker";
    private static final Gauge STREAM_COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe_broker")).name("open_job_stream_count")).help("Number of open job streams in broker")).register();
    private static final Counter PUSH_SUCCESS_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe_broker")).name("jobs_pushed_count")).help("Total number of jobs pushed to all streams")).register();
    private static final Counter PUSH_FAILED_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe_broker")).name("jobs_push_fail_count")).help("Total number of failures when pushing jobs to the streams")).register();
    private static final Counter PUSH_TRY_FAILED_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe_broker")).name("jobs_push_fail_try_count")).help("Total number of failed attempts when pushing jobs to the streams, grouped by code")).labelNames(new String[]{"code"})).register();

    public void addStream() {
        STREAM_COUNT.inc();
    }

    public void removeStream() {
        STREAM_COUNT.dec();
    }

    public void pushSucceeded() {
        PUSH_SUCCESS_COUNT.inc();
    }

    public void pushFailed() {
        PUSH_FAILED_COUNT.inc();
    }

    public void pushTryFailed(ErrorCode code) {
        ((Counter.Child)PUSH_TRY_FAILED_COUNT.labels(new String[]{code.name()})).inc();
    }
}

