/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.stream.ExporterContainer;
import io.camunda.zeebe.broker.exporter.stream.ExporterMetrics;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.impl.records.RecordValues;
import io.camunda.zeebe.stream.impl.records.TypedRecordImpl;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.prometheus.client.Histogram;
import java.time.InstantSource;
import java.util.List;

final class RecordExporter {
    private final RecordValues recordValues = new RecordValues();
    private final RecordMetadata rawMetadata = new RecordMetadata();
    private final List<ExporterContainer> containers;
    private final TypedRecordImpl typedEvent;
    private final ExporterMetrics exporterMetrics;
    private boolean shouldExport;
    private int exporterIndex;
    private final InstantSource clock;

    RecordExporter(ExporterMetrics exporterMetrics, List<ExporterContainer> containers, int partitionId, InstantSource clock) {
        this.containers = containers;
        this.typedEvent = new TypedRecordImpl(partitionId);
        this.exporterMetrics = exporterMetrics;
        this.clock = clock;
    }

    void wrap(LoggedEvent rawEvent) {
        rawEvent.readMetadata((BufferReader)this.rawMetadata);
        UnifiedRecordValue recordValue = this.recordValues.readRecordValue(rawEvent, this.rawMetadata.getValueType());
        boolean bl = this.shouldExport = recordValue != null;
        if (this.shouldExport) {
            this.typedEvent.wrap(rawEvent, this.rawMetadata, recordValue);
            this.exporterIndex = 0;
        }
    }

    boolean export() {
        if (!this.shouldExport) {
            return true;
        }
        ValueType valueType = this.typedEvent.getValueType();
        long currentMillis = this.clock.millis();
        this.exporterMetrics.exportingLatency(valueType, this.typedEvent.getTimestamp(), currentMillis);
        int exportersCount = this.containers.size();
        while (this.exporterIndex < exportersCount) {
            ExporterContainer container = this.containers.get(this.exporterIndex);
            Histogram.Timer timer = this.exporterMetrics.startExporterExportingTimer(valueType, container.getId());
            try {
                if (container.exportRecord(this.rawMetadata, (TypedRecord)this.typedEvent)) {
                    ++this.exporterIndex;
                    this.exporterMetrics.setLastExportedPosition(container.getId(), this.typedEvent.getPosition());
                    continue;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (timer == null) continue;
                timer.close();
            }
        }
        return true;
    }

    TypedRecordImpl getTypedEvent() {
        return this.typedEvent;
    }

    public void resetExporterIndex() {
        this.exporterIndex = 0;
    }
}

