/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ExporterStateEntry
extends UnpackedObject
implements DbValue {
    private static final UnsafeBuffer EMPTY_METADATA = new UnsafeBuffer();
    private final LongProperty positionProp = new LongProperty("exporterPosition");
    private final BinaryProperty metadataProp = new BinaryProperty("exporterMetadata", (DirectBuffer)EMPTY_METADATA);
    private final LongProperty metadataVersionProp = new LongProperty("metadataVersion", 0L);

    public ExporterStateEntry() {
        super(3);
        this.declareProperty((BaseProperty)this.positionProp).declareProperty((BaseProperty)this.metadataProp).declareProperty((BaseProperty)this.metadataVersionProp);
    }

    public long getPosition() {
        return this.positionProp.getValue();
    }

    public ExporterStateEntry setPosition(long position) {
        this.positionProp.setValue(position);
        return this;
    }

    public DirectBuffer getMetadata() {
        return BufferUtil.cloneBuffer((DirectBuffer)this.metadataProp.getValue());
    }

    public ExporterStateEntry setMetadata(DirectBuffer metadata) {
        this.metadataProp.setValue(metadata);
        return this;
    }

    public long getMetadataVersion() {
        return this.metadataVersionProp.getValue();
    }

    public ExporterStateEntry setMetadataVersion(long metadataVersion) {
        this.metadataVersionProp.setValue(metadataVersion);
        return this;
    }
}

