/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.protocol.ExporterStateDecoder;
import io.camunda.zeebe.broker.protocol.ExporterStateEncoder;
import io.camunda.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.HashMap;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.UnsafeBuffer;

public class ExporterStateDistributeMessage
extends SbeBufferWriterReader<ExporterStateEncoder, ExporterStateDecoder> {
    private final Map<String, ExporterStateEntry> exporterState = new HashMap<String, ExporterStateEntry>();
    private final ExporterStateEncoder encoder = new ExporterStateEncoder();
    private final ExporterStateDecoder decoder = new ExporterStateDecoder();

    protected ExporterStateEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected ExporterStateDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        super.reset();
        this.exporterState.clear();
    }

    public int getLength() {
        MutableInteger length = new MutableInteger();
        this.exporterState.forEach((id, state) -> length.addAndGet(ExporterStateEncoder.StateEncoder.positionEncodingLength() + ExporterStateEncoder.StateEncoder.exporterIdHeaderLength() + ExporterStateEncoder.StateEncoder.metadataHeaderLength() + id.length() + state.metadata.capacity()));
        return super.getLength() + ExporterStateEncoder.StateEncoder.sbeHeaderSize() + length.get();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        ExporterStateEncoder.StateEncoder stateEncoder = this.encoder.stateCount(this.exporterState.size());
        this.exporterState.forEach((id, state) -> {
            DirectBuffer idBuffer = BufferUtil.wrapString((String)id);
            DirectBuffer metadata = state.metadata;
            stateEncoder.next().position(state.position).putExporterId(idBuffer, 0, idBuffer.capacity()).putMetadata(metadata, 0, metadata.capacity());
        });
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        ExporterStateDecoder.StateDecoder stateDecoder = this.decoder.state();
        while (stateDecoder.hasNext()) {
            ExporterStateDecoder.StateDecoder next = stateDecoder.next();
            long position = next.position();
            int exporterIdLength = next.exporterIdLength();
            byte[] exporterIdBytes = new byte[exporterIdLength];
            next.getExporterId(exporterIdBytes, 0, exporterIdLength);
            int metadataLength = next.metadataLength();
            byte[] metadataBytes = new byte[metadataLength];
            next.getMetadata(metadataBytes, 0, metadataLength);
            UnsafeBuffer metadataBuffer = new UnsafeBuffer(metadataBytes);
            this.exporterState.put(new String(exporterIdBytes), new ExporterStateEntry(position, (DirectBuffer)metadataBuffer));
        }
    }

    public void putExporter(String exporterId, long lastExportedPosition, DirectBuffer exporterMetadata) {
        this.exporterState.put(exporterId, new ExporterStateEntry(lastExportedPosition, exporterMetadata));
    }

    public Map<String, ExporterStateEntry> getExporterState() {
        return this.exporterState;
    }

    record ExporterStateEntry(long position, DirectBuffer metadata) {
        @Override
        public String toString() {
            return "{position=" + this.position + ", metadata=" + BufferUtil.bufferAsString((DirectBuffer)this.metadata) + "}";
        }
    }
}

