/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.stream.ExporterPhase;
import io.camunda.zeebe.protocol.record.ValueType;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public final class ExporterMetrics {
    private static final String LABEL_NAME_PARTITION = "partition";
    private static final String LABEL_NAME_EXPORTER = "exporter";
    private static final String LABEL_NAME_ACTION = "action";
    private static final String LABEL_NAME_VALUE_TYPE = "valueType";
    private static final String NAMESPACE_ZEEBE = "zeebe";
    private static final Histogram EXPORTING_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("exporting_latency")).help("Time between a record is written until it is picked up for exporting (in seconds)")).labelNames(new String[]{"partition", "valueType"})).register();
    private static final Histogram EXPORTER_EXPORTING_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("exporter_exporting_duration")).help("The time an exporter needs to export certain record (duration in seconds)")).labelNames(new String[]{"partition", "exporter", "valueType"})).register();
    private static final Counter EXPORTER_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("exporter_events_total")).help("Number of events processed by exporter")).labelNames(new String[]{"action", "partition", "valueType"})).register();
    private static final Gauge LAST_EXPORTED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("exporter_last_exported_position")).help("The last exported position by exporter and partition.")).labelNames(new String[]{"exporter", "partition"})).register();
    private static final Gauge LAST_UPDATED_EXPORTED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("exporter_last_updated_exported_position")).help("The last exported position which was also updated/committed by the exporter.")).labelNames(new String[]{"exporter", "partition"})).register();
    private static final Gauge EXPORTER_PHASE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("exporter_state")).help("Describes the phase of the exporter, namely if it is exporting, paused or soft paused.")).labelNames(new String[]{"partition"})).register();
    private final String partitionIdLabel;
    private final Gauge.Child exporterPhase;

    public ExporterMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
        this.exporterPhase = (Gauge.Child)EXPORTER_PHASE.labels(new String[]{this.partitionIdLabel});
    }

    private void event(String action, ValueType valueType) {
        ((Counter.Child)EXPORTER_EVENTS.labels(new String[]{action, this.partitionIdLabel, valueType.name()})).inc();
    }

    public void setExporterActive() {
        this.exporterPhase.set(0.0);
    }

    public void setExporterPaused() {
        this.exporterPhase.set(1.0);
    }

    public void setExporterSoftPaused() {
        this.exporterPhase.set(2.0);
    }

    public void eventExported(ValueType valueType) {
        this.event("exported", valueType);
    }

    public void eventSkipped(ValueType valueType) {
        this.event("skipped", valueType);
    }

    public void setLastUpdatedExportedPosition(String exporter, long position) {
        ((Gauge.Child)LAST_UPDATED_EXPORTED_POSITION.labels(new String[]{exporter, this.partitionIdLabel})).set((double)position);
    }

    public void setLastExportedPosition(String exporter, long position) {
        ((Gauge.Child)LAST_EXPORTED_POSITION.labels(new String[]{exporter, this.partitionIdLabel})).set((double)position);
    }

    public void exportingLatency(ValueType valueType, long written, long exporting) {
        ((Histogram.Child)EXPORTING_LATENCY.labels(new String[]{this.partitionIdLabel, valueType.name()})).observe((double)((float)(exporting - written) / 1000.0f));
    }

    public Histogram.Timer startExporterExportingTimer(ValueType valueType, String exporter) {
        return ((Histogram.Child)EXPORTER_EXPORTING_DURATION.labels(new String[]{this.partitionIdLabel, exporter, valueType.name()})).startTimer();
    }

    public void initializeExporterState(ExporterPhase state) {
        switch (state) {
            case PAUSED: {
                this.setExporterPaused();
                break;
            }
            case SOFT_PAUSED: {
                this.setExporterSoftPaused();
                break;
            }
            default: {
                this.setExporterActive();
            }
        }
    }
}

