/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.system.partitions.PartitionMessagingService;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.stream.api.EventFilter;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.time.InstantSource;
import java.util.Map;

public final class ExporterDirectorContext {
    public static final Duration DEFAULT_DISTRIBUTION_INTERVAL = Duration.ofSeconds(15L);
    private int id;
    private String name;
    private LogStream logStream;
    private Map<ExporterDescriptor, ExporterDirector.ExporterInitializationInfo> descriptors;
    private ZeebeDb zeebeDb;
    private PartitionMessagingService partitionMessagingService;
    private ExporterMode exporterMode = ExporterMode.ACTIVE;
    private Duration distributionInterval = DEFAULT_DISTRIBUTION_INTERVAL;
    private EventFilter positionsToSkipFilter;
    private MeterRegistry meterRegistry;
    private InstantSource clock;

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public LogStream getLogStream() {
        return this.logStream;
    }

    public Map<ExporterDescriptor, ExporterDirector.ExporterInitializationInfo> getDescriptors() {
        return this.descriptors;
    }

    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    public PartitionMessagingService getPartitionMessagingService() {
        return this.partitionMessagingService;
    }

    public ExporterMode getExporterMode() {
        return this.exporterMode;
    }

    public Duration getDistributionInterval() {
        return this.distributionInterval;
    }

    public EventFilter getPositionsToSkipFilter() {
        return this.positionsToSkipFilter;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public InstantSource getClock() {
        return this.clock;
    }

    public ExporterDirectorContext id(int id) {
        this.id = id;
        return this;
    }

    public ExporterDirectorContext name(String name) {
        this.name = name;
        return this;
    }

    public ExporterDirectorContext logStream(LogStream logStream) {
        this.logStream = logStream;
        return this;
    }

    public ExporterDirectorContext descriptors(Map<ExporterDescriptor, ExporterDirector.ExporterInitializationInfo> descriptors) {
        this.descriptors = descriptors;
        return this;
    }

    public ExporterDirectorContext zeebeDb(ZeebeDb zeebeDb) {
        this.zeebeDb = zeebeDb;
        return this;
    }

    public ExporterDirectorContext meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this;
    }

    public ExporterDirectorContext partitionMessagingService(PartitionMessagingService messagingService) {
        this.partitionMessagingService = messagingService;
        return this;
    }

    public ExporterDirectorContext exporterMode(ExporterMode exporterMode) {
        this.exporterMode = exporterMode;
        return this;
    }

    public ExporterDirectorContext distributionInterval(Duration distributionInterval) {
        this.distributionInterval = distributionInterval;
        return this;
    }

    public ExporterDirectorContext positionsToSkipFilter(EventFilter skipPositionsFilter) {
        this.positionsToSkipFilter = skipPositionsFilter;
        return this;
    }

    public ExporterDirectorContext clock(InstantSource clock) {
        this.clock = clock;
        return this;
    }

    public static enum ExporterMode {
        ACTIVE,
        PASSIVE;

    }
}

