/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public class ExecutionLatencyMetrics {
    private static final Duration[] JOB_LIFE_TIME_BUCKETS = (Duration[])Stream.of(25, 50, 75, 100, 250, 500, 750, 1000, 2500, 5000, 10000, 15000, 30000, 45000).map(Duration::ofMillis).toArray(Duration[]::new);
    private static final Duration[] JOB_ACTIVATION_TIME_BUCKETS = (Duration[])Stream.of(10, 25, 50, 75, 100, 250, 500, 750, 1000, 2500, 5000, 10000, 15000, 30000).map(Duration::ofMillis).toArray(Duration[]::new);
    private static final Duration[] PROCESS_INSTANCE_EXECUTION_BUCKETS = (Duration[])Stream.of(50, 75, 100, 250, 500, 750, 1000, 2500, 5000, 10000, 15000, 30000, 45000, 60000).map(Duration::ofMillis).toArray(Duration[]::new);
    private final MeterRegistry meterRegistry;
    private final Map<Integer, AtomicInteger> currentCachedInstanceJobsCount = new ConcurrentHashMap<Integer, AtomicInteger>();
    private final Map<Integer, AtomicInteger> currentCacheInstanceProcessInstances = new ConcurrentHashMap<Integer, AtomicInteger>();
    private final int partitionId;

    public ExecutionLatencyMetrics() {
        this((MeterRegistry)new SimpleMeterRegistry(), 1);
    }

    public ExecutionLatencyMetrics(MeterRegistry meterRegistry, int partitionId) {
        this.meterRegistry = meterRegistry;
        this.partitionId = partitionId;
    }

    public void observeProcessInstanceExecutionTime(long creationTimeMs, long completionTimeMs) {
        Timer.builder((String)"zeebe.process.instance.execution.time").description("The execution time of processing a complete process instance").tag("partition", Integer.toString(this.partitionId)).sla(PROCESS_INSTANCE_EXECUTION_BUCKETS).register(this.meterRegistry).record(completionTimeMs - creationTimeMs, TimeUnit.MILLISECONDS);
    }

    public void observeJobLifeTime(long creationTimeMs, long completionTimeMs) {
        Timer.builder((String)"zeebe.job.life.time").description("The life time of an job").tag("partition", Integer.toString(this.partitionId)).sla(JOB_LIFE_TIME_BUCKETS).register(this.meterRegistry).record(completionTimeMs - creationTimeMs, TimeUnit.MILLISECONDS);
    }

    public void observeJobActivationTime(long creationTimeMs, long activationTimeMs) {
        Timer.builder((String)"zeebe.job.activation.time").description("The time until an job was activated").tag("partition", Integer.toString(this.partitionId)).sla(JOB_ACTIVATION_TIME_BUCKETS).register(this.meterRegistry).record(activationTimeMs - creationTimeMs, TimeUnit.MILLISECONDS);
    }

    public void setCurrentJobsCount(int count) {
        this.setCurrentCachedInstanceGauge(count, "jobs");
    }

    public void setCurrentProcessInstanceCount(int count) {
        this.setCurrentCachedInstanceGauge(count, "processInstances");
    }

    private void setCurrentCachedInstanceGauge(int count, String type) {
        Map<Integer, AtomicInteger> collection = "jobs".equals(type) ? this.currentCachedInstanceJobsCount : this.currentCacheInstanceProcessInstances;
        collection.putIfAbsent(this.partitionId, new AtomicInteger());
        collection.get(this.partitionId).set(count);
        Gauge.builder((String)"zeebe.execution.latency.current.cached.instances", () -> ((AtomicInteger)collection.get(this.partitionId)).get()).description("The current cached instances for counting their execution latency. If only short-lived instances are handled this can be seen or observed as the current active instance count.").tags(new String[]{"type", type, "partition", Integer.toString(this.partitionId)}).register(this.meterRegistry);
    }
}

