/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.context;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

final class ExporterConfigurationListDeserializer<E>
extends StdDelegatingDeserializer<List<E>> {
    public ExporterConfigurationListDeserializer() {
        super(new MapListConverter());
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        return new StdDelegatingDeserializer(new MapListConverter(property.getType().getContentType())).createContextual(ctxt, property);
    }

    private static final class MapListConverter<E>
    extends StdConverter<Map<String, E>, List<E>> {
        private final JavaType contentType;

        public MapListConverter() {
            this(TypeFactory.defaultInstance().constructType(Object.class));
        }

        public MapListConverter(JavaType contentType) {
            this.contentType = contentType;
        }

        public List<E> convert(Map<String, E> value) {
            ArrayList list = new ArrayList(value.size());
            TreeSet<String> keys = new TreeSet<String>(value.keySet());
            for (String key : keys) {
                this.setListValue(value, key, list);
            }
            return list;
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return super.getInputType(typeFactory).withContentType(this.contentType);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return super.getOutputType(typeFactory).withContentType(this.contentType);
        }

        private void setListValue(Map<String, E> value, String key, ArrayList<E> list) {
            int index;
            try {
                index = Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to convert a map of integer to list; at least one key is not a number: [%s]".formatted(key), e);
            }
            try {
                list.add(index, value.get(key));
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("Failed to convert map of integers to list; tried to insert at [%d], but highest index is [%d]. Check your configuration for errors when setting the index.".formatted(index, list.size() - 1));
            }
        }
    }
}

