/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine.impl;

import io.camunda.zeebe.broker.engine.impl.BoundedCommandCache;
import io.camunda.zeebe.broker.engine.impl.ScheduledCommandCacheMetrics;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.scheduling.ScheduledCommandCache;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.agrona.collections.LongHashSet;

public final class BoundedScheduledCommandCache
implements ScheduledCommandCache.StageableScheduledCommandCache {
    private final Map<Intent, BoundedCommandCache> caches;

    public BoundedScheduledCommandCache(Map<Intent, BoundedCommandCache> caches) {
        this.caches = caches;
    }

    public static BoundedScheduledCommandCache ofIntent(ScheduledCommandCacheMetrics metrics, Intent ... intents) {
        Map<Intent, BoundedCommandCache> caches = Arrays.stream(intents).collect(Collectors.toMap(Function.identity(), intent -> new BoundedCommandCache(metrics.forIntent((Intent)intent))));
        return new BoundedScheduledCommandCache(caches);
    }

    public void add(Intent intent, long key) {
        BoundedCommandCache cache = this.caches.get(intent);
        if (cache != null) {
            LongHashSet singleton = new LongHashSet();
            singleton.add(key);
            cache.add(singleton);
        }
    }

    public boolean contains(Intent intent, long key) {
        BoundedCommandCache cache = this.caches.get(intent);
        return cache != null && cache.contains(key);
    }

    public void remove(Intent intent, long key) {
        BoundedCommandCache cache = this.caches.get(intent);
        if (cache != null) {
            cache.remove(key);
        }
    }

    public void clear() {
        this.caches.values().forEach(BoundedCommandCache::clear);
    }

    public ScheduledCommandCache.StagedScheduledCommandCache stage() {
        return new StagedCache();
    }

    private final class StagedCache
    implements ScheduledCommandCache.StagedScheduledCommandCache {
        private final Map<Intent, LongHashSet> stagedKeys = new HashMap<Intent, LongHashSet>();

        private StagedCache() {
        }

        public void add(Intent intent, long key) {
            this.stagedKeys(intent).add(key);
        }

        public boolean contains(Intent intent, long key) {
            return this.stagedKeys(intent).contains(key) || BoundedScheduledCommandCache.this.caches.containsKey(intent) && BoundedScheduledCommandCache.this.caches.get(intent).contains(key);
        }

        public void remove(Intent intent, long key) {
            this.stagedKeys(intent).remove(key);
        }

        public void clear() {
            this.stagedKeys.values().forEach(Set::clear);
        }

        public void persist() {
            for (Map.Entry<Intent, LongHashSet> entry : this.stagedKeys.entrySet()) {
                BoundedCommandCache cache = BoundedScheduledCommandCache.this.caches.get(entry.getKey());
                if (cache == null) continue;
                cache.add(entry.getValue());
            }
        }

        private LongHashSet stagedKeys(Intent intent) {
            return this.stagedKeys.computeIfAbsent(intent, ignored -> new LongHashSet());
        }
    }
}

