/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine.impl;

import io.camunda.zeebe.util.LockUtil;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntConsumer;
import org.agrona.collections.LongHashSet;

public final class BoundedCommandCache {
    private static final int DEFAULT_CAPACITY = 100000;
    private final Lock lock = new ReentrantLock();
    private final int capacity;
    private final LongHashSet cache;
    private final IntConsumer sizeReporter;

    public BoundedCommandCache(int capacity) {
        this(capacity, ignored -> {});
    }

    public BoundedCommandCache(IntConsumer sizeReporter) {
        this(100000, sizeReporter);
    }

    public BoundedCommandCache(int capacity, IntConsumer sizeReporter) {
        this.capacity = capacity;
        this.sizeReporter = sizeReporter;
        int resizeThreshold = (int)Math.ceil((float)capacity * 0.9f);
        int capacityToPreventResize = 2 * capacity - resizeThreshold;
        this.cache = new LongHashSet(capacityToPreventResize, 0.9f, true);
        sizeReporter.accept(0);
    }

    public void add(LongHashSet keys) {
        LockUtil.withLock((Lock)this.lock, () -> this.lockedAdd(keys));
    }

    public boolean contains(long key) {
        return (Boolean)LockUtil.withLock((Lock)this.lock, () -> this.cache.contains(key));
    }

    public void remove(long key) {
        LockUtil.withLock((Lock)this.lock, () -> {
            this.cache.remove(key);
            this.sizeReporter.accept(this.cache.size());
        });
    }

    public int size() {
        return (Integer)LockUtil.withLock((Lock)this.lock, () -> ((LongHashSet)this.cache).size());
    }

    public void clear() {
        LockUtil.withLock((Lock)this.lock, () -> {
            this.cache.clear();
            this.sizeReporter.accept(0);
        });
    }

    private void lockedAdd(LongHashSet keys) {
        int evictionCount = this.cache.size() + keys.size() - this.capacity;
        if (evictionCount > 0) {
            this.evict(evictionCount);
        }
        this.cache.addAll(keys);
        this.sizeReporter.accept(this.cache.size());
    }

    private void evict(int count) {
        int evictionStartIndex = ThreadLocalRandom.current().nextInt(0, this.capacity - count + 1);
        int evictionEndIndex = evictionStartIndex + count;
        LongHashSet.LongIterator iterator = this.cache.iterator();
        for (int i = 0; i < evictionEndIndex && iterator.hasNext(); ++i) {
            iterator.next();
            if (i < evictionStartIndex) continue;
            iterator.remove();
        }
    }
}

