/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.clustering;

import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.MemberConfig;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.discovery.BootstrapDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.protocol.GroupMembershipProtocolConfig;
import io.atomix.cluster.protocol.SwimMembershipProtocolConfig;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.MembershipCfg;
import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import io.camunda.zeebe.broker.system.configuration.SecurityCfg;
import io.camunda.zeebe.broker.system.configuration.SocketBindingCfg;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public final class ClusterConfigFactory {
    public ClusterConfig mapConfiguration(BrokerCfg config) {
        ClusterCfg cluster = config.getCluster();
        String name = cluster.getClusterName();
        BootstrapDiscoveryConfig discovery = this.discoveryConfig(cluster.getInitialContactPoints());
        SwimMembershipProtocolConfig membership = this.membershipConfig(cluster.getMembership());
        NetworkCfg network = config.getNetwork();
        MessagingConfig messaging = this.messagingConfig(cluster, network);
        MemberConfig member = this.memberConfig(network.getInternalApi(), cluster.getNodeId());
        return new ClusterConfig().setClusterId(name).setNodeConfig(member).setDiscoveryConfig((NodeDiscoveryConfig)discovery).setMessagingConfig(messaging).setProtocolConfig((GroupMembershipProtocolConfig)membership);
    }

    private MemberConfig memberConfig(SocketBindingCfg network, int nodeId) {
        Address advertisedAddress = Address.from((String)network.getAdvertisedHost(), (int)network.getAdvertisedPort());
        return new MemberConfig().setAddress(advertisedAddress).setId(String.valueOf(nodeId));
    }

    private SwimMembershipProtocolConfig membershipConfig(MembershipCfg config) {
        return new SwimMembershipProtocolConfig().setBroadcastDisputes(config.isBroadcastDisputes()).setBroadcastUpdates(config.isBroadcastUpdates()).setFailureTimeout(config.getFailureTimeout()).setGossipFanout(config.getGossipFanout()).setGossipInterval(config.getGossipInterval()).setNotifySuspect(config.isNotifySuspect()).setProbeInterval(config.getProbeInterval()).setProbeTimeout(config.getProbeTimeout()).setSuspectProbes(config.getSuspectProbes()).setSyncInterval(config.getSyncInterval());
    }

    private BootstrapDiscoveryConfig discoveryConfig(Collection<String> contactPoints) {
        Set nodes = contactPoints.stream().map(Address::from).map(address -> new NodeConfig().setAddress(address)).collect(Collectors.toSet());
        return new BootstrapDiscoveryConfig().setNodes(nodes);
    }

    private MessagingConfig messagingConfig(ClusterCfg cluster, NetworkCfg network) {
        MessagingConfig messaging = new MessagingConfig().setCompressionAlgorithm(cluster.getMessageCompression()).setInterfaces(Collections.singletonList(network.getInternalApi().getHost())).setPort(Integer.valueOf(network.getInternalApi().getPort()));
        if (network.getSecurity().isEnabled()) {
            SecurityCfg security = network.getSecurity();
            messaging.setTlsEnabled(true).configureTls(security.getKeyStore().getFilePath(), security.getKeyStore().getPassword(), security.getPrivateKeyPath(), security.getCertificateChainPath());
        }
        return messaging;
    }
}

