/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.SnowflakeIdGenerator;
import org.agrona.concurrent.SystemEpochClock;

public class RequestIdGeneratorStep
implements StartupStep<BrokerStartupContext> {
    private static final long TIMESTAMP_OFFSET_2023 = 1672531200000L;

    public String getName() {
        return "Request Id Generator";
    }

    public ActorFuture<BrokerStartupContext> startup(BrokerStartupContext brokerStartupContext) {
        ActorFuture started = brokerStartupContext.getConcurrencyControl().createFuture();
        BrokerInfo brokerInfo = brokerStartupContext.getBrokerInfo();
        SnowflakeIdGenerator requestIdGenerator = new SnowflakeIdGenerator(10, 12, (long)brokerInfo.getNodeId(), 1672531200000L, (EpochClock)SystemEpochClock.INSTANCE);
        brokerStartupContext.setRequestIdGenerator(requestIdGenerator);
        started.complete((Object)brokerStartupContext);
        return started;
    }

    public ActorFuture<BrokerStartupContext> shutdown(BrokerStartupContext brokerStartupContext) {
        ActorFuture stopFuture = brokerStartupContext.getConcurrencyControl().createFuture();
        brokerStartupContext.setRequestIdGenerator(null);
        stopFuture.complete((Object)brokerStartupContext);
        return stopFuture;
    }
}

