/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingService;
import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import org.agrona.concurrent.IdGenerator;
import org.agrona.concurrent.SnowflakeIdGenerator;

final class GatewayBrokerTransportStep
extends AbstractBrokerStartupStep {
    GatewayBrokerTransportStep() {
    }

    public String getName() {
        return "Broker Transport";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        concurrencyControl.run(() -> this.startServerTransport(brokerStartupContext, startupFuture));
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        this.closeServerTransport(brokerShutdownContext, concurrencyControl, shutdownFuture);
    }

    private void startServerTransport(BrokerStartupContext brokerStartupContext, ActorFuture<BrokerStartupContext> startupFuture) {
        ConcurrencyControl concurrencyControl = brokerStartupContext.getConcurrencyControl();
        ActorSchedulingService schedulingService = brokerStartupContext.getActorSchedulingService();
        ManagedMessagingService messagingService = brokerStartupContext.getApiMessagingService();
        SnowflakeIdGenerator requestIdGenerator = brokerStartupContext.getRequestIdGenerator();
        AtomixServerTransport atomixServerTransport = new AtomixServerTransport((MessagingService)messagingService, (IdGenerator)requestIdGenerator);
        concurrencyControl.runOnCompletion(schedulingService.submitActor((Actor)atomixServerTransport), this.proceed(() -> {
            brokerStartupContext.setGatewayBrokerTransport(atomixServerTransport);
            startupFuture.complete((Object)brokerStartupContext);
        }, startupFuture));
    }

    private void closeServerTransport(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        AtomixServerTransport serverTransport = brokerShutdownContext.getGatewayBrokerTransport();
        if (serverTransport == null) {
            return;
        }
        concurrencyControl.runOnCompletion(serverTransport.closeAsync(), this.proceed(() -> {
            brokerShutdownContext.setGatewayBrokerTransport(null);
            shutdownFuture.complete((Object)brokerShutdownContext);
        }, shutdownFuture));
    }
}

