/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiServiceImpl;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.transport.ServerTransport;

final class CommandApiServiceStep
extends AbstractBrokerStartupStep {
    CommandApiServiceStep() {
    }

    public String getName() {
        return "Command API";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        concurrencyControl.run(() -> this.startCommandApiService(brokerStartupContext, (ServerTransport)brokerStartupContext.getGatewayBrokerTransport(), startupFuture));
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        CommandApiServiceImpl commandApiServiceActor = brokerShutdownContext.getCommandApiService();
        brokerShutdownContext.removePartitionListener(commandApiServiceActor);
        brokerShutdownContext.getDiskSpaceUsageMonitor().removeDiskUsageListener(commandApiServiceActor);
        concurrencyControl.runOnCompletion(commandApiServiceActor.closeAsync(), this.proceed(() -> {
            brokerShutdownContext.setCommandApiService(null);
            shutdownFuture.complete((Object)brokerShutdownContext);
        }, shutdownFuture));
    }

    private void startCommandApiService(BrokerStartupContext brokerStartupContext, ServerTransport serverTransport, ActorFuture<BrokerStartupContext> startupFuture) {
        ConcurrencyControl concurrencyControl = brokerStartupContext.getConcurrencyControl();
        BrokerCfg brokerCfg = brokerStartupContext.getBrokerConfiguration();
        ActorSchedulingService schedulingService = brokerStartupContext.getActorSchedulingService();
        CommandApiServiceImpl commandApiService = new CommandApiServiceImpl(serverTransport, schedulingService, brokerCfg.getExperimental().getQueryApi());
        concurrencyControl.runOnCompletion(schedulingService.submitActor((Actor)commandApiService), this.proceed(() -> {
            brokerStartupContext.setCommandApiService(commandApiService);
            brokerStartupContext.addPartitionListener(commandApiService);
            brokerStartupContext.getDiskSpaceUsageMonitor().addDiskUsageListener(commandApiService);
            startupFuture.complete((Object)brokerStartupContext);
        }, startupFuture));
    }
}

