/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.partitioning.topology.ClusterConfigurationService;
import io.camunda.zeebe.broker.partitioning.topology.DynamicClusterConfigurationService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.startup.StartupStep;

public class ClusterConfigurationManagerStep
implements StartupStep<BrokerStartupContext> {
    public String getName() {
        return "Cluster Topology Manager";
    }

    public ActorFuture<BrokerStartupContext> startup(BrokerStartupContext brokerStartupContext) {
        ActorFuture started = brokerStartupContext.getConcurrencyControl().createFuture();
        DynamicClusterConfigurationService clusterConfigurationService = new DynamicClusterConfigurationService();
        clusterConfigurationService.start(brokerStartupContext).onComplete((ignore, error) -> {
            if (error == null) {
                brokerStartupContext.setClusterConfigurationService(clusterConfigurationService);
                started.complete((Object)brokerStartupContext);
            } else {
                started.completeExceptionally(error);
            }
        });
        return started;
    }

    public ActorFuture<BrokerStartupContext> shutdown(BrokerStartupContext brokerStartupContext) {
        ActorFuture stopFuture = brokerStartupContext.getConcurrencyControl().createFuture();
        ClusterConfigurationService clusterTopologyService = brokerStartupContext.getClusterConfigurationService();
        if (clusterTopologyService != null) {
            clusterTopologyService.closeAsync().onComplete((ignore, error) -> {
                if (error == null) {
                    brokerStartupContext.setClusterConfigurationService(null);
                    stopFuture.complete((Object)brokerStartupContext);
                } else {
                    stopFuture.completeExceptionally(error);
                }
            });
        } else {
            stopFuture.complete((Object)brokerStartupContext);
        }
        return stopFuture;
    }
}

