/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.Gateway;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListenerEventType;
import io.camunda.zeebe.model.bpmn.util.ModelUtil;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class GatewayValidator
implements ModelElementValidator<Gateway> {
    public Class<Gateway> getElementType() {
        return Gateway.class;
    }

    public void validate(Gateway element, ValidationResultCollector validationResultCollector) {
        ModelUtil.validateExecutionListenersDefinitionForElement(element, validationResultCollector, listeners -> {
            boolean endExecutionListenersDefined = listeners.stream().map(ZeebeExecutionListener::getEventType).anyMatch(ZeebeExecutionListenerEventType.end::equals);
            if (endExecutionListenersDefined) {
                validationResultCollector.addError(0, "Execution listeners of type 'end' are not supported by gateway element");
            }
        });
    }
}

