/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.gcs;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.NoCredentials;
import java.io.IOException;
import java.util.Objects;

record GcsConnectionConfig(String host, Authentication auth) {
    GcsConnectionConfig(String host, Authentication auth) {
        this.host = host;
        this.auth = Objects.requireNonNullElseGet(auth, Authentication.Auto::new);
    }

    static sealed interface Authentication {
        public Credentials credentials();

        public record Auto() implements Authentication
        {
            @Override
            public Credentials credentials() {
                try {
                    return GoogleCredentials.getApplicationDefault().createScoped(new String[]{"https://www.googleapis.com/auth/devstorage.read_write"});
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to retrieve application default credentials", e);
                }
            }
        }

        public record None() implements Authentication
        {
            @Override
            public Credentials credentials() {
                return NoCredentials.getInstance();
            }
        }
    }
}

