/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.gcs;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.NamedFileSet;
import io.camunda.zeebe.backup.common.FileSet;
import io.camunda.zeebe.backup.common.NamedFileSetImpl;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;

final class FileSetManager {
    private static final String PATH_FORMAT = "%scontents/%s/%s/%s/%s/";
    private final Storage client;
    private final BucketInfo bucketInfo;
    private final String basePath;

    FileSetManager(Storage client, BucketInfo bucketInfo, String basePath) {
        this.client = client;
        this.bucketInfo = bucketInfo;
        this.basePath = basePath;
    }

    void save(BackupIdentifier id, String fileSetName, NamedFileSet fileSet) {
        for (Map.Entry namedFile : fileSet.namedFiles().entrySet()) {
            String fileName = (String)namedFile.getKey();
            Path filePath = (Path)namedFile.getValue();
            try {
                this.client.createFrom(this.blobInfo(id, fileSetName, fileName), filePath, new Storage.BlobWriteOption[]{Storage.BlobWriteOption.doesNotExist()});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void delete(BackupIdentifier id, String fileSetName) {
        for (Blob blob : this.client.list(this.bucketInfo.getName(), new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)this.fileSetPath(id, fileSetName))}).iterateAll()) {
            blob.delete(new Blob.BlobSourceOption[0]);
        }
    }

    public NamedFileSet restore(BackupIdentifier id, String filesetName, FileSet fileSet, Path targetFolder) {
        Map<String, Path> pathByName = fileSet.files().stream().collect(Collectors.toMap(FileSet.NamedFile::name, f -> targetFolder.resolve(f.name())));
        for (Map.Entry<String, Path> entry : pathByName.entrySet()) {
            String fileName = entry.getKey();
            Path filePath = entry.getValue();
            this.client.downloadTo(this.blobInfo(id, filesetName, fileName).getBlobId(), filePath, new Storage.BlobSourceOption[0]);
        }
        return new NamedFileSetImpl(pathByName);
    }

    private String fileSetPath(BackupIdentifier id, String fileSetName) {
        return PATH_FORMAT.formatted(this.basePath, id.partitionId(), id.checkpointId(), id.nodeId(), fileSetName);
    }

    private BlobInfo blobInfo(BackupIdentifier id, String fileSetName, String fileName) {
        return BlobInfo.newBuilder((BucketInfo)this.bucketInfo, (String)(this.fileSetPath(id, fileSetName) + fileName)).setContentType("application/octet-stream").build();
    }
}

