/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.common;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.camunda.zeebe.backup.api.Backup;
import io.camunda.zeebe.backup.api.BackupDescriptor;
import io.camunda.zeebe.backup.api.BackupIdentifier;
import io.camunda.zeebe.backup.api.BackupStatus;
import io.camunda.zeebe.backup.api.BackupStatusCode;
import io.camunda.zeebe.backup.common.BackupDescriptorImpl;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.common.BackupStatusImpl;
import io.camunda.zeebe.backup.common.FileSet;
import io.camunda.zeebe.backup.common.ManifestImpl;
import java.time.Instant;
import java.util.Optional;

@JsonSerialize(as=ManifestImpl.class)
@JsonDeserialize(as=ManifestImpl.class)
public sealed interface Manifest {
    public static InProgressManifest createInProgress(Backup backup) {
        Instant creationTime = Instant.now();
        return new ManifestImpl(BackupIdentifierImpl.from((BackupIdentifier)backup.id()), BackupDescriptorImpl.from((BackupDescriptor)backup.descriptor()), StatusCode.IN_PROGRESS, FileSet.of(backup.snapshot()), FileSet.of(backup.segments()), creationTime, creationTime);
    }

    public static FailedManifest createFailed(BackupIdentifier id) {
        Instant creationTime = Instant.now();
        return new ManifestImpl(BackupIdentifierImpl.from((BackupIdentifier)id), null, StatusCode.FAILED, null, null, creationTime, creationTime);
    }

    public BackupIdentifierImpl id();

    public BackupDescriptorImpl descriptor();

    public StatusCode statusCode();

    public Instant createdAt();

    public Instant modifiedAt();

    public InProgressManifest asInProgress();

    public CompletedManifest asCompleted();

    public FailedManifest asFailed();

    public static BackupStatus toStatus(Manifest manifest) {
        return switch (manifest.statusCode().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new BackupStatusImpl((BackupIdentifier)manifest.id(), Optional.ofNullable(manifest.descriptor()), BackupStatusCode.IN_PROGRESS, Optional.empty(), Optional.ofNullable(manifest.createdAt()), Optional.ofNullable(manifest.modifiedAt()));
            case 1 -> new BackupStatusImpl((BackupIdentifier)manifest.id(), Optional.ofNullable(manifest.descriptor()), BackupStatusCode.COMPLETED, Optional.empty(), Optional.ofNullable(manifest.createdAt()), Optional.ofNullable(manifest.modifiedAt()));
            case 2 -> new BackupStatusImpl((BackupIdentifier)manifest.id(), Optional.ofNullable(manifest.descriptor()), BackupStatusCode.FAILED, Optional.ofNullable(manifest.asFailed().failureReason()), Optional.ofNullable(manifest.createdAt()), Optional.ofNullable(manifest.modifiedAt()));
        };
    }

    public static enum StatusCode {
        IN_PROGRESS,
        COMPLETED,
        FAILED;

    }

    public static sealed interface FailedManifest
    extends Manifest
    permits ManifestImpl {
        public String failureReason();
    }

    public static sealed interface CompletedManifest
    extends Manifest
    permits ManifestImpl {
        public FailedManifest fail(String var1);

        public FileSet snapshot();

        public FileSet segments();
    }

    public static sealed interface InProgressManifest
    extends Manifest
    permits ManifestImpl {
        public CompletedManifest complete();

        public FailedManifest fail(String var1);
    }
}

