/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.backup.common;

import io.camunda.zeebe.backup.common.BackupDescriptorImpl;
import io.camunda.zeebe.backup.common.BackupIdentifierImpl;
import io.camunda.zeebe.backup.common.BackupStoreException;
import io.camunda.zeebe.backup.common.FileSet;
import io.camunda.zeebe.backup.common.Manifest;
import java.time.Instant;

public record ManifestImpl(BackupIdentifierImpl id, BackupDescriptorImpl descriptor, Manifest.StatusCode statusCode, FileSet snapshot, FileSet segments, Instant createdAt, Instant modifiedAt, String failureReason) implements Manifest.InProgressManifest,
Manifest.CompletedManifest,
Manifest.FailedManifest
{
    public static final String ERROR_MSG_WRONG_STATE = "Expected a failed Manifest to set failureReason '%s', but was in state '%s'.";

    public ManifestImpl {
        if (failureReason != null && statusCode != Manifest.StatusCode.FAILED) {
            throw new BackupStoreException.InvalidPersistedManifestState(ERROR_MSG_WRONG_STATE.formatted(new Object[]{failureReason, statusCode}));
        }
    }

    public ManifestImpl(BackupIdentifierImpl id, BackupDescriptorImpl descriptor, Manifest.StatusCode statusCode, FileSet snapshot, FileSet segments, Instant createdAt, Instant modifiedAt) {
        this(id, descriptor, statusCode, snapshot, segments, createdAt, modifiedAt, null);
    }

    @Override
    public Manifest.CompletedManifest complete() {
        return new ManifestImpl(this.id, this.descriptor, Manifest.StatusCode.COMPLETED, this.snapshot, this.segments, this.createdAt, Instant.now());
    }

    @Override
    public Manifest.FailedManifest fail(String failureReason) {
        return new ManifestImpl(this.id, this.descriptor, Manifest.StatusCode.FAILED, this.snapshot, this.segments, this.createdAt, Instant.now(), failureReason);
    }

    @Override
    public Manifest.InProgressManifest asInProgress() {
        if (this.statusCode != Manifest.StatusCode.IN_PROGRESS) {
            throw new BackupStoreException.UnexpectedManifestState(Manifest.StatusCode.IN_PROGRESS, this.statusCode);
        }
        return this;
    }

    @Override
    public Manifest.CompletedManifest asCompleted() {
        if (this.statusCode != Manifest.StatusCode.COMPLETED) {
            throw new BackupStoreException.UnexpectedManifestState(Manifest.StatusCode.COMPLETED, this.statusCode);
        }
        return this;
    }

    @Override
    public Manifest.FailedManifest asFailed() {
        if (this.statusCode != Manifest.StatusCode.FAILED) {
            throw new BackupStoreException.UnexpectedManifestState(Manifest.StatusCode.FAILED, this.statusCode);
        }
        return this;
    }
}

