/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.oauth;

import io.camunda.tasklist.property.ClientProperties;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.webapp.security.WebSecurityConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!identity-auth"})
public class OAuth2WebConfigurer {
    public static final String SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_ISSUER_URI = "spring.security.oauth2.resourceserver.jwt.issuer-uri";
    public static final String SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI = "spring.security.oauth2.resourceserver.jwt.jwk-set-uri";
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2WebConfigurer.class);
    @Autowired
    private Environment env;
    @Autowired
    private TasklistProperties config;
    private final CustomJwtAuthenticationConverter jwtConverter = new CustomJwtAuthenticationConverter();

    public void configure(HttpSecurity http) throws Exception {
        if (this.isJWTEnabled()) {
            http.oauth2ResourceServer(serverCustomizer -> serverCustomizer.authenticationEntryPoint(this::authenticationFailure).jwt(jwtCustomizer -> jwtCustomizer.jwtAuthenticationConverter((Converter)this.jwtConverter)));
            LOGGER.info("Enabled OAuth2 JWT access to REST API");
        }
    }

    private void authenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException {
        request.getSession().invalidate();
        WebSecurityConfig.sendJSONErrorMessage(response, e.getMessage());
    }

    protected boolean isJWTEnabled() {
        return this.env.containsProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_ISSUER_URI) || this.env.containsProperty(SPRING_SECURITY_OAUTH_2_RESOURCESERVER_JWT_JWK_SET_URI);
    }

    class CustomJwtAuthenticationConverter
    implements Converter<Jwt, AbstractAuthenticationToken> {
        public static final String AUDIENCE = "aud";
        public static final String CLUSTER_ID = "https://camunda.com/clusterId";
        private final JwtAuthenticationConverter delegate = new JwtAuthenticationConverter();

        CustomJwtAuthenticationConverter() {
        }

        public AbstractAuthenticationToken convert(Jwt jwt) {
            JwtAuthenticationToken auth = (JwtAuthenticationToken)this.delegate.convert(jwt);
            Map payload = auth.getTokenAttributes();
            if (this.isValid(payload)) {
                return auth;
            }
            throw new InvalidBearerTokenException("JWT payload validation failed");
        }

        private boolean isValid(Map<String, Object> payload) {
            try {
                String audience = this.getAudience(payload);
                String clusterId = this.getClusterId(payload);
                ClientProperties clientConfig = OAuth2WebConfigurer.this.config.getClient();
                return clientConfig.getAudience().equals(audience) && clientConfig.getClusterId().equals(clusterId);
            }
            catch (Exception e) {
                LOGGER.warn("Validation of JWT payload failed. Request is not authenticated.");
                return false;
            }
        }

        private String getClusterId(Map<String, Object> payload) {
            return (String)payload.get(CLUSTER_ID);
        }

        private String getAudience(Map<String, Object> payload) {
            return (String)CollectionUtil.firstOrDefault((List)((List)CollectionUtil.getOrDefaultFromMap(payload, (Object)AUDIENCE, Collections.emptyList())), null);
        }
    }
}

