/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.oauth;

import io.camunda.identity.sdk.Identity;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.SpringContextHolder;
import io.camunda.tasklist.webapp.security.tenant.TasklistTenant;
import io.camunda.tasklist.webapp.security.tenant.TenantAwareAuthentication;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class IdentityTenantAwareJwtAuthenticationToken
extends JwtAuthenticationToken
implements TenantAwareAuthentication {
    private static final long serialVersionUID = 1L;
    private List<TasklistTenant> tenants = Collections.emptyList();

    public IdentityTenantAwareJwtAuthenticationToken(Jwt jwt, Collection<? extends GrantedAuthority> authorities, String name) {
        super(jwt, authorities, name);
    }

    @Override
    public List<TasklistTenant> getTenants() {
        if (CollectionUtils.isEmpty(this.tenants) && this.isMultiTenancyEnabled()) {
            this.tenants = this.retrieveTenants();
        }
        return this.tenants;
    }

    private List<TasklistTenant> retrieveTenants() {
        try {
            String token = ((Jwt)this.getToken()).getTokenValue();
            List identityTenants = this.getIdentity().tenants().forToken(token);
            if (CollectionUtils.isEmpty((Collection)identityTenants)) {
                return Collections.emptyList();
            }
            return identityTenants.stream().map(t -> new TasklistTenant(t.getTenantId(), t.getName())).sorted(TENANT_NAMES_COMPARATOR).toList();
        }
        catch (Exception e) {
            throw new InsufficientAuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    private Identity getIdentity() {
        return (Identity)SpringContextHolder.getBean(Identity.class);
    }

    private boolean isMultiTenancyEnabled() {
        return ((TasklistProperties)SpringContextHolder.getBean(TasklistProperties.class)).getMultiTenancy().isEnabled();
    }
}

