/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.rest;

import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.webapp.rest.exception.APIException;
import io.camunda.tasklist.webapp.rest.exception.Error;
import io.camunda.tasklist.webapp.rest.exception.ForbiddenActionException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.security.TasklistProfileService;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class InternalAPIErrorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalAPIErrorController.class);
    @Autowired
    private TasklistProfileService tasklistProfileService;

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={TasklistRuntimeException.class})
    public ResponseEntity<Error> handleException(TasklistRuntimeException exception) {
        LOGGER.warn(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value()).setMessage(this.tasklistProfileService.getMessageByProfileFor((Exception)((Object)exception)));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={APIException.class})
    public ResponseEntity<Error> handleInternalAPIException(APIException exception) {
        LOGGER.warn(String.format("Instance: %s; %s", exception.getInstance(), exception.getMessage()));
        Error error = new Error().setStatus(HttpStatus.BAD_REQUEST.value()).setInstance(exception.getInstance()).setMessage(this.tasklistProfileService.getMessageByProfileFor(exception));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={ForbiddenActionException.class})
    public ResponseEntity<Error> handleAccessDeniedException(ForbiddenActionException exception) {
        LOGGER.warn(exception.getMessage(), (Throwable)exception);
        Error error = new Error().setInstance(UUID.randomUUID().toString()).setStatus(HttpStatus.FORBIDDEN.value()).setMessage(exception.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundApiException.class})
    public ResponseEntity<Error> handleNotFound(NotFoundApiException exception) {
        LOGGER.warn(String.format("Instance: %s; %s", exception.getInstance(), exception.getMessage()));
        Error error = new Error().setStatus(HttpStatus.NOT_FOUND.value()).setInstance(exception.getInstance()).setMessage(this.tasklistProfileService.getMessageByProfileFor(exception));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_PROBLEM_JSON).body((Object)error);
    }
}

