/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.graphql.resolvers;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.kickstart.annotations.GraphQLMutationResolver;
import io.camunda.tasklist.entities.TaskImplementation;
import io.camunda.tasklist.enums.DeletionStatus;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.store.ProcessInstanceStore;
import io.camunda.tasklist.util.SpringContextHolder;
import io.camunda.tasklist.webapp.graphql.entity.ProcessInstanceDTO;
import io.camunda.tasklist.webapp.graphql.entity.TaskDTO;
import io.camunda.tasklist.webapp.graphql.entity.VariableInputDTO;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.service.ProcessService;
import io.camunda.tasklist.webapp.service.TaskService;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@GraphQLMutationResolver
public class Mutations {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mutations.class);
    private static final String ZEEBE_USER_TASK_OPERATIONS_NOT_SUPPORTED = "This operation is not supported using Tasklist graphql API. Please use the latest REST API. For more information, refer to the documentation: %s";

    @GraphQLField
    @GraphQLNonNull
    public static TaskDTO completeTask(String taskId, List<VariableInputDTO> variables) {
        return Mutations.delegate(() -> {
            Mutations.checkTaskImplementation(taskId);
            return ((TaskService)SpringContextHolder.getBean(TaskService.class)).completeTask(taskId, variables, false);
        });
    }

    @GraphQLField
    @GraphQLNonNull
    public static TaskDTO claimTask(String taskId, String assignee, Boolean allowOverrideAssignment) {
        return Mutations.delegate(() -> {
            Mutations.checkTaskImplementation(taskId);
            return ((TaskService)SpringContextHolder.getBean(TaskService.class)).assignTask(taskId, assignee, allowOverrideAssignment);
        });
    }

    @GraphQLField
    @GraphQLNonNull
    public static TaskDTO unclaimTask(String taskId) {
        return Mutations.delegate(() -> {
            Mutations.checkTaskImplementation(taskId);
            return ((TaskService)SpringContextHolder.getBean(TaskService.class)).unassignTask(taskId);
        });
    }

    @GraphQLField
    @GraphQLNonNull
    public static Boolean deleteProcessInstance(String processInstanceId) {
        return Mutations.delegate(() -> DeletionStatus.DELETED.equals((Object)((ProcessInstanceStore)SpringContextHolder.getBean(ProcessInstanceStore.class)).deleteProcessInstance(processInstanceId)));
    }

    @GraphQLField
    @GraphQLNonNull
    public static ProcessInstanceDTO startProcess(String processDefinitionId) {
        return Mutations.delegate(() -> ((ProcessService)SpringContextHolder.getBean(ProcessService.class)).startProcessInstance(processDefinitionId, "<default>"));
    }

    private static <T> T delegate(Supplier<T> supplier) {
        return ((MutationAuthorizationDelegate)SpringContextHolder.getBean(MutationAuthorizationDelegate.class)).call(supplier);
    }

    private static void checkTaskImplementation(String taskId) {
        TaskDTO task = ((TaskService)SpringContextHolder.getBean(TaskService.class)).getTask(taskId);
        if (task.getImplementation() != TaskImplementation.JOB_WORKER) {
            LOGGER.warn("GraphQL API is used for task with id={} implementation={}", (Object)task.getId(), (Object)task.getImplementation());
            throw new InvalidRequestException(String.format(ZEEBE_USER_TASK_OPERATIONS_NOT_SUPPORTED, ((TasklistProperties)SpringContextHolder.getBean(TasklistProperties.class)).getDocumentation().getApiMigrationDocsUrl()));
        }
    }

    @Component
    public static class MutationAuthorizationDelegate {
        @PreAuthorize(value="hasPermission('write')")
        public <T> T call(Supplier<T> supplier) {
            return supplier.get();
        }
    }
}

