/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.graphql.entity;

import graphql.annotations.annotationTypes.GraphQLConstructor;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@GraphQLType
@GraphQLName(value="VariableInput")
public class VariableInputDTO {
    @Schema(description="The name of the variable.")
    @GraphQLField
    @GraphQLNonNull
    private String name;
    @Schema(description="The value of the variable. When specifying the variable value, it's crucial to maintain consistency with JSON values (serialization for the complex objects such as list) and ensure that strings remain appropriately formatted.")
    @GraphQLField
    @GraphQLNonNull
    private String value;

    @GraphQLConstructor
    public VariableInputDTO(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public VariableInputDTO() {
    }

    public String getName() {
        return this.name;
    }

    public VariableInputDTO setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public VariableInputDTO setValue(String value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableInputDTO that = (VariableInputDTO)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }
}

