/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.entities;

import io.camunda.tasklist.entities.DraftTaskVariableEntity;
import io.camunda.tasklist.entities.TaskVariableEntity;
import io.camunda.tasklist.entities.VariableEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.StringJoiner;

public class VariableSearchResponse {
    @Schema(description="The unique identifier of the variable.")
    private String id;
    @Schema(description="The name of the variable.")
    private String name;
    @Schema(description="The value of the variable.")
    private String value;
    @Schema(description="Does the `previewValue` contain the truncated value or full value?")
    private boolean isValueTruncated;
    @Schema(description="A preview of the variable's value. Limited in size.")
    private String previewValue;
    @Schema(description="The draft value of the variable.")
    private DraftSearchVariableValue draft;

    public String getId() {
        return this.id;
    }

    public VariableSearchResponse setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public VariableSearchResponse setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public VariableSearchResponse setValue(String value) {
        this.value = value;
        return this;
    }

    public VariableSearchResponse resetValue() {
        this.value = null;
        return this;
    }

    public boolean getIsValueTruncated() {
        return this.isValueTruncated;
    }

    public VariableSearchResponse setIsValueTruncated(boolean valueTruncated) {
        this.isValueTruncated = valueTruncated;
        return this;
    }

    public String getPreviewValue() {
        return this.previewValue;
    }

    public VariableSearchResponse setPreviewValue(String previewValue) {
        this.previewValue = previewValue;
        return this;
    }

    public DraftSearchVariableValue getDraft() {
        return this.draft;
    }

    public VariableSearchResponse setDraft(DraftSearchVariableValue draft) {
        this.draft = draft;
        return this;
    }

    public VariableSearchResponse addDraft(DraftTaskVariableEntity draftTaskVariable) {
        this.draft = new DraftSearchVariableValue().setValue(draftTaskVariable.getFullValue()).setIsValueTruncated(draftTaskVariable.getIsPreview()).setPreviewValue(draftTaskVariable.getValue());
        return this;
    }

    public static VariableSearchResponse createFrom(VariableEntity variableEntity) {
        return new VariableSearchResponse().setId(variableEntity.getId()).setName(variableEntity.getName()).setValue(variableEntity.getFullValue()).setIsValueTruncated(variableEntity.getIsPreview()).setPreviewValue(variableEntity.getValue());
    }

    public static VariableSearchResponse createFrom(VariableEntity variableEntity, DraftTaskVariableEntity draftTaskVariable) {
        return VariableSearchResponse.createFrom(variableEntity).setDraft(new DraftSearchVariableValue().setValue(draftTaskVariable.getFullValue()).setIsValueTruncated(draftTaskVariable.getIsPreview()).setPreviewValue(draftTaskVariable.getValue()));
    }

    public static VariableSearchResponse createFrom(DraftTaskVariableEntity draftTaskVariable) {
        return new VariableSearchResponse().setId(draftTaskVariable.getId()).setName(draftTaskVariable.getName()).setDraft(new DraftSearchVariableValue().setValue(draftTaskVariable.getFullValue()).setIsValueTruncated(draftTaskVariable.getIsPreview()).setPreviewValue(draftTaskVariable.getValue()));
    }

    public static VariableSearchResponse createFrom(TaskVariableEntity variableEntity) {
        return new VariableSearchResponse().setId(variableEntity.getId()).setName(variableEntity.getName()).setPreviewValue(variableEntity.getValue()).setIsValueTruncated(variableEntity.getIsPreview()).setValue(variableEntity.getFullValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableSearchResponse that = (VariableSearchResponse)o;
        return this.isValueTruncated == that.isValueTruncated && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.previewValue, that.previewValue) && Objects.equals(this.draft, that.draft);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.value, this.isValueTruncated, this.previewValue, this.draft);
    }

    public String toString() {
        return new StringJoiner(", ", VariableSearchResponse.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("name='" + this.name + "'").add("value='" + this.value + "'").add("isValueTruncated=" + this.isValueTruncated).add("previewValue='" + this.previewValue + "'").add("draft=" + String.valueOf(this.draft)).toString();
    }

    public static class DraftSearchVariableValue {
        @Schema(description="The value of the variable.")
        private String value;
        @Schema(description="Does the `previewValue` contain the truncated value or full value?")
        private boolean isValueTruncated;
        @Schema(description="A preview of the variable's value. Limited in size.")
        private String previewValue;

        public String getValue() {
            return this.value;
        }

        public DraftSearchVariableValue setValue(String value) {
            this.value = value;
            return this;
        }

        public DraftSearchVariableValue resetValue() {
            this.value = null;
            return this;
        }

        public boolean getIsValueTruncated() {
            return this.isValueTruncated;
        }

        public DraftSearchVariableValue setIsValueTruncated(boolean valueTruncated) {
            this.isValueTruncated = valueTruncated;
            return this;
        }

        public String getPreviewValue() {
            return this.previewValue;
        }

        public DraftSearchVariableValue setPreviewValue(String previewValue) {
            this.previewValue = previewValue;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DraftSearchVariableValue that = (DraftSearchVariableValue)o;
            return this.isValueTruncated == that.isValueTruncated && Objects.equals(this.value, that.value) && Objects.equals(this.previewValue, that.previewValue);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.isValueTruncated, this.previewValue);
        }

        public String toString() {
            return new StringJoiner(", ", DraftSearchVariableValue.class.getSimpleName() + "[", "]").add("value='" + this.value + "'").add("isValueTruncated=" + this.isValueTruncated).add("previewValue='" + this.previewValue + "'").toString();
        }
    }
}

