/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.sso;

import com.auth0.AuthenticationController;
import com.auth0.IdentityVerificationException;
import com.auth0.Tokens;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.security.Permission;
import io.camunda.tasklist.webapp.security.sso.TokenAuthentication;
import io.camunda.tasklist.webapp.security.sso.model.ClusterInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.List;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@Profile(value={"sso-auth"})
public class Auth0Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(Auth0Service.class);
    private static final String LOGOUT_URL_TEMPLATE = "https://%s/v2/logout?client_id=%s&returnTo=%s";
    private static final String PERMISSION_URL_TEMPLATE = "%s/%s";
    private static final List<String> SCOPES = List.of("openid", "profile", "email", "offline_access");
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private AuthenticationController authenticationController;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="auth0_restTemplate")
    private RestTemplate restTemplate;

    public Authentication authenticate(HttpServletRequest req, HttpServletResponse res) {
        Tokens tokens = this.retrieveTokens(req, res);
        TokenAuthentication authentication = (TokenAuthentication)this.beanFactory.getBean(TokenAuthentication.class);
        authentication.authenticate(tokens.getIdToken(), tokens.getRefreshToken(), tokens.getAccessToken());
        this.checkPermission(authentication);
        return authentication;
    }

    private void checkPermission(TokenAuthentication authentication) {
        ClusterInfo.Permission tasklistPermissions;
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(authentication.getAccessToken());
        String urlDomain = this.tasklistProperties.getCloud().getPermissionUrl();
        String url = String.format(PERMISSION_URL_TEMPLATE, urlDomain, this.tasklistProperties.getAuth0().getOrganization());
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), ClusterInfo.class, new Object[0]);
        ClusterInfo clusterInfo = (ClusterInfo)responseEntity.getBody();
        if (clusterInfo.getSalesPlan() != null) {
            authentication.setSalesPlanType(clusterInfo.getSalesPlan().getType());
        }
        if (!(tasklistPermissions = clusterInfo.getPermissions().getCluster().getTasklist()).getRead().booleanValue()) {
            throw new InsufficientAuthenticationException("User doesn't have read access");
        }
        authentication.addPermission(Permission.READ);
        if (tasklistPermissions.getDelete().booleanValue() && tasklistPermissions.getCreate().booleanValue() && tasklistPermissions.getUpdate().booleanValue()) {
            authentication.addPermission(Permission.WRITE);
        }
    }

    public String getAuthorizeUrl(HttpServletRequest req, HttpServletResponse res) {
        return this.authenticationController.buildAuthorizeUrl(req, res, this.getRedirectURI(req, "/sso-callback", true)).withAudience(this.tasklistProperties.getCloud().getPermissionAudience()).withScope(String.join((CharSequence)" ", SCOPES)).build();
    }

    public String getLogoutUrlFor(String returnTo) {
        return String.format(LOGOUT_URL_TEMPLATE, this.tasklistProperties.getAuth0().getDomain(), this.tasklistProperties.getAuth0().getClientId(), returnTo);
    }

    public Tokens retrieveTokens(HttpServletRequest req, HttpServletResponse res) {
        String operationName = "retrieve tokens";
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handle(IdentityVerificationException.class)).withDelay(Duration.ofMillis(500L)).withMaxAttempts(10).onRetry(e -> LOGGER.debug("Retrying #{} {}", (Object)e.getAttemptCount(), (Object)"retrieve tokens")).onAbort(e -> LOGGER.error("Abort {} by {}", (Object)"retrieve tokens", (Object)e.getFailure())).onRetriesExceeded(e -> LOGGER.error("Retries {} exceeded for {}", (Object)e.getAttemptCount(), (Object)"retrieve tokens"));
        return (Tokens)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.authenticationController.handle(req, res));
    }

    public String getRedirectURI(HttpServletRequest req, String redirectTo) {
        return this.getRedirectURI(req, redirectTo, false);
    }

    public String getRedirectURI(HttpServletRequest req, String redirectTo, boolean omitContextPath) {
        String redirectUri = req.getScheme() + "://" + req.getServerName();
        if (req.getScheme().equals("http") && req.getServerPort() != 80 || req.getScheme().equals("https") && req.getServerPort() != 443) {
            redirectUri = redirectUri + ":" + req.getServerPort();
        }
        String clusterId = req.getContextPath().replace("/", "");
        if (omitContextPath) {
            return redirectUri + redirectTo + "?uuid=" + clusterId;
        }
        return redirectUri + req.getContextPath() + redirectTo;
    }
}

