/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.identity;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.identity.sdk.exception.IdentityException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthentication;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import java.util.UUID;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.function.CheckedSupplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"identity-auth"})
public class IdentityService {
    private static final int DELAY_IN_MILLISECONDS = 500;
    private static final int MAX_ATTEMPTS = 10;
    @Autowired
    private Identity identity;
    @Autowired
    private TasklistProperties tasklistProperties;

    public String getRedirectUrl(HttpServletRequest req) {
        return this.identity.authentication().authorizeUriBuilder(this.getRedirectURI(req, "/identity-callback")).build().toString();
    }

    public void logout() {
        IdentityAuthentication authentication = (IdentityAuthentication)SecurityContextHolder.getContext().getAuthentication();
        this.identity.authentication().revokeToken(authentication.getTokens().getRefreshToken());
    }

    public static <T> T requestWithRetry(CheckedSupplier<T> operation) {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handle(IdentityException.class)).withDelay(Duration.ofMillis(500L)).withMaxAttempts(10);
        return (T)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(operation);
    }

    public String getRedirectURI(HttpServletRequest req, String redirectTo) {
        String result;
        Object redirectRootUri;
        String fixedRedirectRootUrl = this.tasklistProperties.getIdentity().getRedirectRootUrl();
        if (StringUtils.isNotBlank((CharSequence)fixedRedirectRootUrl)) {
            redirectRootUri = fixedRedirectRootUrl;
        } else {
            redirectRootUri = req.getScheme() + "://" + req.getServerName();
            if (req.getScheme().equals("http") && req.getServerPort() != 80 || req.getScheme().equals("https") && req.getServerPort() != 443) {
                redirectRootUri = (String)redirectRootUri + ":" + req.getServerPort();
            }
        }
        if (this.contextPathIsUUID(req.getContextPath())) {
            String clusterId = req.getContextPath().replace("/", "");
            result = (String)redirectRootUri + redirectTo + "?uuid=" + clusterId;
        } else {
            result = (String)redirectRootUri + req.getContextPath() + redirectTo;
        }
        return result;
    }

    private boolean contextPathIsUUID(String contextPath) {
        try {
            UUID.fromString(contextPath.replace("/", ""));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public IdentityAuthentication getAuthenticationFor(HttpServletRequest req, AuthCodeDto authCodeDto) {
        Tokens tokens = (Tokens)IdentityService.requestWithRetry(() -> this.identity.authentication().exchangeAuthCode(authCodeDto, this.getRedirectURI(req, "/identity-callback")));
        IdentityAuthentication authentication = new IdentityAuthentication();
        authentication.authenticate(tokens);
        return authentication;
    }
}

