/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security;

import io.camunda.tasklist.webapp.security.TasklistProfileService;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class TasklistProfileServiceImpl
implements TasklistProfileService {
    private static final Set<String> CANT_LOGOUT_AUTH_PROFILES = Set.of("sso-auth");
    @Autowired
    private Environment environment;

    @Override
    public String getMessageByProfileFor(Exception exception) {
        if (this.isDevelopmentProfileActive()) {
            return exception.getMessage();
        }
        return "";
    }

    @Override
    public boolean currentProfileCanLogout() {
        return Arrays.stream(this.environment.getActiveProfiles()).noneMatch(CANT_LOGOUT_AUTH_PROFILES::contains);
    }

    @Override
    public boolean isLoginDelegated() {
        return this.isIdentityProfile() || this.isSSOProfile();
    }

    private boolean isDevelopmentProfileActive() {
        return List.of(this.environment.getActiveProfiles()).contains("dev");
    }

    private boolean isSSOProfile() {
        return Arrays.asList(this.environment.getActiveProfiles()).contains("sso-auth");
    }

    private boolean isIdentityProfile() {
        return Arrays.asList(this.environment.getActiveProfiles()).contains("identity-auth");
    }
}

