/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.backup.os;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.snapshot.GetSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.SnapshotInfo;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
final class GetCustomSnapshotResponse
implements JsonpSerializable {
    public static final JsonpDeserializer<GetCustomSnapshotResponse> DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCustomSnapshotResponse::setupGetSnapshotResponseDeserializer);
    public static final Endpoint<GetSnapshotRequest, GetCustomSnapshotResponse, ErrorResponse> ENDPOINT = new SimpleEndpoint(request -> "GET", request -> {
        boolean repository = true;
        int snapshot = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode((String)request.repository(), (StringBuilder)buf);
            buf.append("/");
            SimpleEndpoint.pathEncode((String)request.snapshot().stream().collect(Collectors.joining(",")), (StringBuilder)buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound((String)"path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout() != null) {
            params.put("master_timeout", request.masterTimeout()._toJsonString());
        }
        if (request.clusterManagerTimeout() != null) {
            params.put("cluster_manager_timeout", request.clusterManagerTimeout()._toJsonString());
        }
        if (request.includeRepository() != null) {
            params.put("include_repository", String.valueOf(request.includeRepository()));
        }
        if (request.ignoreUnavailable() != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable()));
        }
        if (request.indexDetails() != null) {
            params.put("index_details", String.valueOf(request.indexDetails()));
        }
        if (request.human() != null) {
            params.put("human", String.valueOf(request.human()));
        }
        if (request.verbose() != null) {
            params.put("verbose", String.valueOf(request.verbose()));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DESERIALIZER);
    private final List<SnapshotInfo> snapshots;

    private GetCustomSnapshotResponse(Builder builder) {
        this.snapshots = ApiTypeHelper.unmodifiable(builder.snapshots);
    }

    public static GetCustomSnapshotResponse of(Function<Builder, ObjectBuilder<GetCustomSnapshotResponse>> fn) {
        return (GetCustomSnapshotResponse)fn.apply(new Builder()).build();
    }

    public final List<SnapshotInfo> snapshots() {
        return this.snapshots;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.snapshots)) {
            generator.writeKey("snapshots");
            generator.writeStartArray();
            for (SnapshotInfo item0 : this.snapshots) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetSnapshotResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::snapshots, JsonpDeserializer.arrayDeserializer((JsonpDeserializer)SnapshotInfo._DESERIALIZER), "snapshots");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetCustomSnapshotResponse> {
        @Nullable
        private List<SnapshotInfo> snapshots;

        public final Builder snapshots(List<SnapshotInfo> list) {
            this.snapshots = Builder._listAddAll(this.snapshots, list);
            return this;
        }

        public final Builder snapshots(SnapshotInfo value, SnapshotInfo ... values) {
            this.snapshots = Builder._listAdd(this.snapshots, (Object)value, (Object[])values);
            return this;
        }

        public final Builder snapshots(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.snapshots((SnapshotInfo)fn.apply(new SnapshotInfo.Builder()).build(), new SnapshotInfo[0]);
        }

        public GetCustomSnapshotResponse build() {
            this._checkSingleUse();
            return new GetCustomSnapshotResponse(this);
        }
    }
}

