/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.backup.es;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.TasklistElasticsearchConnectionException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.es.backup.BackupManager;
import io.camunda.tasklist.webapp.es.backup.Metadata;
import io.camunda.tasklist.webapp.management.dto.BackupStateDto;
import io.camunda.tasklist.webapp.management.dto.GetBackupStateResponseDetailDto;
import io.camunda.tasklist.webapp.management.dto.GetBackupStateResponseDto;
import io.camunda.tasklist.webapp.management.dto.TakeBackupRequestDto;
import io.camunda.tasklist.webapp.management.dto.TakeBackupResponseDto;
import io.camunda.tasklist.webapp.rest.exception.InvalidRequestException;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Configuration
@Conditional(value={ElasticSearchCondition.class})
public class BackupManagerElasticSearch
extends BackupManager {
    public static final String SNAPSHOT_MISSING_EXCEPTION_TYPE = "type=snapshot_missing_exception";
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupManagerElasticSearch.class);
    private static final String REPOSITORY_MISSING_EXCEPTION_TYPE = "type=repository_missing_exception";
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    private final Queue<CreateSnapshotRequest> requestsQueue = new ConcurrentLinkedQueue<CreateSnapshotRequest>();

    @Override
    public void deleteBackup(Long backupId) {
        this.validateRepositoryExists();
        String repositoryName = this.getRepositoryName();
        int count = this.getIndexPatternsOrdered().length;
        String version = this.getCurrentTasklistVersion();
        for (int index = 0; index < count; ++index) {
            String snapshotName = new Metadata().setVersion(version).setPartCount(count).setPartNo(index + 1).setBackupId(backupId).buildSnapshotName();
            DeleteSnapshotRequest request = new DeleteSnapshotRequest(repositoryName);
            request.snapshots(new String[]{snapshotName});
            this.esClient.snapshot().deleteAsync(request, RequestOptions.DEFAULT, this.getDeleteListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TakeBackupResponseDto takeBackup(TakeBackupRequestDto request) {
        this.validateRepositoryExists();
        this.validateNoDuplicateBackupId(request.getBackupId());
        if (this.requestsQueue.size() > 0) {
            throw new InvalidRequestException("Another backup is running at the moment");
        }
        Queue<CreateSnapshotRequest> queue = this.requestsQueue;
        synchronized (queue) {
            if (this.requestsQueue.size() > 0) {
                throw new InvalidRequestException("Another backup is running at the moment");
            }
            return this.scheduleSnapshots(request);
        }
    }

    @Override
    public GetBackupStateResponseDto getBackupState(Long backupId) {
        List<SnapshotInfo> snapshots = this.findSnapshots(backupId);
        return this.getBackupResponse(backupId, snapshots);
    }

    @Override
    public List<GetBackupStateResponseDto> getBackups() {
        GetSnapshotsRequest snapshotsStatusRequest = new GetSnapshotsRequest().repository(this.getRepositoryName()).snapshots(new String[]{"camunda_tasklist_*"}).sort(GetSnapshotsRequest.SortBy.START_TIME).order(SortOrder.DESC);
        try {
            GetSnapshotsResponse response = this.esClient.snapshot().get(snapshotsStatusRequest, RequestOptions.DEFAULT);
            List snapshots = response.getSnapshots().stream().sorted(Comparator.comparing(SnapshotInfo::startTime).reversed()).collect(Collectors.toList());
            LinkedHashMap groupedSnapshotInfos = snapshots.stream().collect(Collectors.groupingBy(si -> {
                Metadata metadata = (Metadata)this.objectMapper.convertValue((Object)si.userMetadata(), Metadata.class);
                Long backupId = metadata.getBackupId();
                if (backupId == null) {
                    backupId = Metadata.extractBackupIdFromSnapshotName(si.snapshotId().getName());
                }
                return backupId;
            }, LinkedHashMap::new, Collectors.toList()));
            return groupedSnapshotInfos.entrySet().stream().map(entry -> this.getBackupResponse((Long)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
        }
        catch (IOException | TransportException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while searching for snapshots. Repository name: [%s].", this.getRepositoryName());
            throw new TasklistElasticsearchConnectionException(reason, ex);
        }
        catch (Exception e) {
            if (this.isRepositoryMissingException(e)) {
                String reason = String.format("No repository with name [%s] could be found.", this.tasklistProperties.getBackup().getRepositoryName());
                throw new TasklistRuntimeException(reason);
            }
            if (this.isSnapshotMissingException(e)) {
                return new ArrayList<GetBackupStateResponseDto>();
            }
            String reason = String.format("Exception occurred when searching for backups: %s", e.getMessage());
            throw new TasklistRuntimeException(reason, (Throwable)e);
        }
    }

    private ActionListener<AcknowledgedResponse> getDeleteListener() {
        return new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                LOGGER.debug("Delete snapshot was acknowledged by Elasticsearch node: " + response.isAcknowledged());
            }

            public void onFailure(Exception e) {
                if (BackupManagerElasticSearch.this.isSnapshotMissingException(e)) {
                    LOGGER.warn("No snapshot found for snapshot deletion: " + e.getMessage());
                } else {
                    LOGGER.error("Exception occurred while deleting the snapshot: " + e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    private boolean isSnapshotMissingException(Exception e) {
        return e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)e).getDetailedMessage().contains(SNAPSHOT_MISSING_EXCEPTION_TYPE);
    }

    private boolean isRepositoryMissingException(Exception e) {
        return e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)e).getDetailedMessage().contains(REPOSITORY_MISSING_EXCEPTION_TYPE);
    }

    private TakeBackupResponseDto scheduleSnapshots(TakeBackupRequestDto request) {
        String repositoryName = this.getRepositoryName();
        int count = this.getIndexPatternsOrdered().length;
        ArrayList<String> snapshotNames = new ArrayList<String>();
        String version = this.getCurrentTasklistVersion();
        for (int index = 0; index < count; ++index) {
            String[] indexPattern = this.getIndexPatternsOrdered()[index];
            Metadata metadata = new Metadata().setVersion(version).setPartCount(count).setPartNo(index + 1).setBackupId(request.getBackupId());
            String snapshotName = metadata.buildSnapshotName();
            this.requestsQueue.offer(new CreateSnapshotRequest().repository(repositoryName).snapshot(snapshotName).indices(indexPattern).indicesOptions(IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true)).includeGlobalState(true).userMetadata((Map)this.objectMapper.convertValue((Object)metadata, (TypeReference)new TypeReference<Map<String, Object>>(this){})).featureStates(new String[]{"none"}).waitForCompletion(true));
            LOGGER.debug("Snapshot scheduled: " + snapshotName);
            snapshotNames.add(snapshotName);
        }
        this.scheduleNextSnapshot();
        return new TakeBackupResponseDto().setScheduledSnapshots(snapshotNames);
    }

    private void scheduleNextSnapshot() {
        CreateSnapshotRequest nextRequest = this.requestsQueue.poll();
        if (nextRequest != null) {
            this.getTaskExecutor().submit(() -> this.executeSnapshotting(nextRequest));
            LOGGER.debug("Snapshot picked for execution: " + nextRequest.getDescription());
        }
    }

    private void validateRepositoryExists() {
        String repositoryName = this.getRepositoryName();
        GetRepositoriesRequest getRepositoriesRequest = new GetRepositoriesRequest().repositories(new String[]{repositoryName});
        try {
            this.getRepository(getRepositoriesRequest);
        }
        catch (IOException | TransportException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while retrieving repository with name [%s].", repositoryName);
            throw new TasklistElasticsearchConnectionException(reason, ex);
        }
        catch (Exception e) {
            if (this.isRepositoryMissingException(e)) {
                String reason = String.format("No repository with name [%s] could be found.", repositoryName);
                throw new TasklistRuntimeException(reason);
            }
            String reason = String.format("Exception occurred when validating existence of repository with name [%s].", repositoryName);
            throw new TasklistRuntimeException(reason, (Throwable)e);
        }
    }

    private GetRepositoriesResponse getRepository(GetRepositoriesRequest getRepositoriesRequest) throws IOException {
        return this.esClient.snapshot().getRepository(getRepositoriesRequest, RequestOptions.DEFAULT);
    }

    private void validateNoDuplicateBackupId(Long backupId) {
        GetSnapshotsResponse response;
        GetSnapshotsRequest snapshotsStatusRequest = new GetSnapshotsRequest().repository(this.getRepositoryName()).snapshots(new String[]{Metadata.buildSnapshotNamePrefix(backupId) + "*"});
        try {
            response = this.esClient.snapshot().get(snapshotsStatusRequest, RequestOptions.DEFAULT);
        }
        catch (IOException | TransportException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while searching for duplicate backup. Repository name: [%s].", this.getRepositoryName());
            throw new TasklistElasticsearchConnectionException(reason, ex);
        }
        catch (Exception e) {
            if (this.isSnapshotMissingException(e)) {
                return;
            }
            String reason = String.format("Exception occurred when validating whether backup with ID [%s] already exists.", backupId);
            throw new TasklistRuntimeException(reason, (Throwable)e);
        }
        if (!response.getSnapshots().isEmpty()) {
            String reason = String.format("A backup with ID [%s] already exists. Found snapshots: [%s]", backupId, response.getSnapshots().stream().map(snapshotInfo -> snapshotInfo.snapshotId().toString()).collect(Collectors.joining(", ")));
            throw new InvalidRequestException(reason);
        }
    }

    private void executeSnapshotting(CreateSnapshotRequest snapshotRequest) {
        this.esClient.snapshot().createAsync(snapshotRequest, RequestOptions.DEFAULT, this.getSnapshotActionListener());
    }

    /*
     * Unable to fully structure code
     */
    private GetBackupStateResponseDto getBackupResponse(Long backupId, List<SnapshotInfo> snapshots) {
        response = new GetBackupStateResponseDto(backupId);
        metadata = (Metadata)this.objectMapper.convertValue((Object)snapshots.get(0).userMetadata(), Metadata.class);
        expectedSnapshotsCount = metadata.getPartCount();
        if (snapshots.size() != expectedSnapshotsCount.intValue()) ** GOTO lbl-1000
        if (snapshots.stream().map((Function<SnapshotInfo, SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Lorg/elasticsearch/snapshots/SnapshotState;)()).allMatch((Predicate<SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/elasticsearch/snapshots/SnapshotState;)Z)((SnapshotState)SnapshotState.SUCCESS))) {
            response.setState(BackupStateDto.COMPLETED);
        } else if (snapshots.stream().map((Function<SnapshotInfo, SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Lorg/elasticsearch/snapshots/SnapshotState;)()).anyMatch((Predicate<SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBackupResponse$4(org.elasticsearch.snapshots.SnapshotState ), (Lorg/elasticsearch/snapshots/SnapshotState;)Z)())) {
            response.setState(BackupStateDto.FAILED);
        } else if (snapshots.stream().map((Function<SnapshotInfo, SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Lorg/elasticsearch/snapshots/SnapshotState;)()).anyMatch((Predicate<SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/elasticsearch/snapshots/SnapshotState;)Z)((SnapshotState)SnapshotState.INCOMPATIBLE))) {
            response.setState(BackupStateDto.INCOMPATIBLE);
        } else if (snapshots.stream().map((Function<SnapshotInfo, SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, state(), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Lorg/elasticsearch/snapshots/SnapshotState;)()).anyMatch((Predicate<SnapshotState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lorg/elasticsearch/snapshots/SnapshotState;)Z)((SnapshotState)SnapshotState.IN_PROGRESS))) {
            response.setState(BackupStateDto.IN_PROGRESS);
        } else if (snapshots.size() < expectedSnapshotsCount) {
            response.setState(BackupStateDto.INCOMPLETE);
        } else {
            response.setState(BackupStateDto.FAILED);
        }
        details = new ArrayList<GetBackupStateResponseDetailDto>();
        for (SnapshotInfo snapshot : snapshots) {
            detail = new GetBackupStateResponseDetailDto();
            detail.setSnapshotName(snapshot.snapshotId().getName());
            detail.setStartTime(OffsetDateTime.ofInstant(Instant.ofEpochMilli(snapshot.startTime()), ZoneId.systemDefault()));
            if (snapshot.shardFailures() != null) {
                detail.setFailures((String[])snapshot.shardFailures().stream().map((Function<SnapshotShardFailure, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/elasticsearch/snapshots/SnapshotShardFailure;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$getBackupResponse$5(int ), (I)[Ljava/lang/String;)()));
            }
            detail.setState(snapshot.state().name());
            details.add(detail);
        }
        response.setDetails(details);
        if (response.getState().equals((Object)BackupStateDto.FAILED)) {
            failureReason = null;
            failedSnapshots = snapshots.stream().filter((Predicate<SnapshotInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBackupResponse$6(org.elasticsearch.snapshots.SnapshotInfo ), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Z)()).map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBackupResponse$7(org.elasticsearch.snapshots.SnapshotInfo ), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", "));
            if (!failedSnapshots.isEmpty()) {
                failureReason = String.format("There were failures with the following snapshots: %s", new Object[]{failedSnapshots});
            } else {
                partialSnapshot = snapshots.stream().filter((Predicate<SnapshotInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBackupResponse$8(org.elasticsearch.snapshots.SnapshotInfo ), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Z)()).map((Function<SnapshotInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBackupResponse$9(org.elasticsearch.snapshots.SnapshotInfo ), (Lorg/elasticsearch/snapshots/SnapshotInfo;)Ljava/lang/String;)()).collect(Collectors.joining(", "));
                if (!partialSnapshot.isEmpty()) {
                    failureReason = String.format("Some of the snapshots are partial: %s", new Object[]{partialSnapshot});
                } else if (snapshots.size() > expectedSnapshotsCount) {
                    failureReason = "More snapshots found than expected.";
                }
            }
            if (failureReason != null) {
                response.setFailureReason(failureReason);
            }
        }
        return response;
    }

    private List<SnapshotInfo> findSnapshots(Long backupId) {
        GetSnapshotsRequest snapshotsStatusRequest = new GetSnapshotsRequest().repository(this.getRepositoryName()).snapshots(new String[]{Metadata.buildSnapshotNamePrefix(backupId) + "*"});
        try {
            GetSnapshotsResponse response = this.esClient.snapshot().get(snapshotsStatusRequest, RequestOptions.DEFAULT);
            return response.getSnapshots();
        }
        catch (IOException | TransportException ex) {
            String reason = String.format("Encountered an error connecting to Elasticsearch while searching for snapshots. Repository name: [%s].", this.getRepositoryName());
            throw new TasklistElasticsearchConnectionException(reason, ex);
        }
        catch (Exception e) {
            if (this.isSnapshotMissingException(e)) {
                throw new NotFoundApiException(String.format("No backup with id [%s] found.", backupId), e);
            }
            if (this.isRepositoryMissingException(e)) {
                String reason = String.format("No repository with name [%s] could be found.", this.tasklistProperties.getBackup().getRepositoryName());
                throw new TasklistRuntimeException(reason);
            }
            String reason = String.format("Exception occurred when searching for backup with ID [%s].", backupId);
            throw new TasklistRuntimeException(reason, (Throwable)e);
        }
    }

    @Bean(value={"tasklistBackupThreadPoolExecutor"})
    public ThreadPoolTaskExecutor getTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(1);
        executor.setMaxPoolSize(1);
        executor.setThreadNamePrefix("backup_es_");
        executor.setQueueCapacity(6);
        executor.initialize();
        return executor;
    }

    @Bean
    public ActionListener<CreateSnapshotResponse> getSnapshotActionListener() {
        return new ActionListener<CreateSnapshotResponse>(){

            public void onResponse(CreateSnapshotResponse response) {
                switch (response.getSnapshotInfo().state()) {
                    case SUCCESS: {
                        LOGGER.info("Snapshot done: " + String.valueOf(response.getSnapshotInfo().snapshotId()));
                        BackupManagerElasticSearch.this.scheduleNextSnapshot();
                        break;
                    }
                    case FAILED: {
                        LOGGER.error("Snapshot taking failed for {}, reason {}", (Object)response.getSnapshotInfo().snapshotId(), (Object)response.getSnapshotInfo().reason());
                        BackupManagerElasticSearch.this.requestsQueue.clear();
                        break;
                    }
                    default: {
                        LOGGER.warn("Snapshot status {} for the {}", (Object)response.getSnapshotInfo().state(), (Object)response.getSnapshotInfo().snapshotId());
                        BackupManagerElasticSearch.this.scheduleNextSnapshot();
                    }
                }
            }

            public void onFailure(Exception e) {
                LOGGER.error("Exception occurred while creating snapshot: " + e.getMessage(), (Throwable)e);
                BackupManagerElasticSearch.this.requestsQueue.clear();
            }
        };
    }

    private static /* synthetic */ String lambda$getBackupResponse$9(SnapshotInfo s) {
        return s.snapshotId().getName();
    }

    private static /* synthetic */ boolean lambda$getBackupResponse$8(SnapshotInfo s) {
        return s.state().equals((Object)SnapshotState.PARTIAL);
    }

    private static /* synthetic */ String lambda$getBackupResponse$7(SnapshotInfo s) {
        return s.snapshotId().getName();
    }

    private static /* synthetic */ boolean lambda$getBackupResponse$6(SnapshotInfo s) {
        return s.state().equals((Object)SnapshotState.FAILED);
    }

    private static /* synthetic */ String[] lambda$getBackupResponse$5(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ boolean lambda$getBackupResponse$4(SnapshotState s) {
        return SnapshotState.FAILED.equals((Object)s) || SnapshotState.PARTIAL.equals((Object)s);
    }
}

