/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.os;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.NoSuchIndexException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.camunda.tasklist.zeebe.ImportValueType;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.RecordsReaderAbstract;
import io.camunda.tasklist.zeebeimport.os.ImportBatchOpenSearch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Conditional(value={OpenSearchCondition.class})
public class RecordsReaderOpenSearch
extends RecordsReaderAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordsReaderOpenSearch.class);
    @Autowired
    @Qualifier(value="tasklistZeebeOsClient")
    private OpenSearchClient zeebeOsClient;

    public RecordsReaderOpenSearch(int partitionId, ImportValueType importValueType, int queueSize) {
        super(partitionId, importValueType, queueSize);
    }

    private Hit[] withTimerSearchHits(Callable<Hit[]> callable) throws Exception {
        return (Hit[])this.metrics.getTimer("tasklist.import.query", new String[]{"type", this.importValueType.name(), "partition", String.valueOf(this.partitionId)}).recordCallable(callable);
    }

    private ImportBatch createImportBatch(SearchResponse searchResponse) {
        List hits = searchResponse.hits().hits();
        String indexName = null;
        if (hits.size() > 0) {
            indexName = ((Hit)hits.get(hits.size() - 1)).index();
        }
        return new ImportBatchOpenSearch(this.partitionId, this.importValueType, hits, indexName);
    }

    private ImportBatch createImportBatch(Hit[] hits) {
        String indexName = null;
        if (hits.length > 0) {
            indexName = hits[hits.length - 1].index();
        }
        return new ImportBatchOpenSearch(this.partitionId, this.importValueType, Arrays.asList(hits), indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hit[] read(SearchRequest.Builder searchRequest, boolean scrollNeeded) throws IOException {
        Hit[] hitArray;
        block6: {
            String scrollId = null;
            try {
                if (scrollNeeded) {
                    searchRequest.scroll(Time.of(t -> t.time("60000ms")));
                }
                SearchResponse response = this.zeebeOsClient.search(searchRequest.build(), Object.class);
                ArrayList searchHits = new ArrayList(response.hits().hits());
                if (scrollNeeded) {
                    scrollId = response.scrollId();
                    do {
                        ScrollRequest scrollRequest = new ScrollRequest.Builder().scrollId(scrollId).scroll(Time.of(t -> t.time("60000ms"))).build();
                        response = this.zeebeOsClient.scroll(scrollRequest, Object.class);
                        scrollId = response.scrollId();
                        searchHits.addAll(response.hits().hits());
                    } while (response.hits().hits().size() != 0);
                }
                hitArray = searchHits.toArray(new Hit[0]);
                if (scrollId == null) break block6;
            }
            catch (Throwable throwable) {
                if (scrollId != null) {
                    OpenSearchUtil.clearScroll(scrollId, (OpenSearchClient)this.zeebeOsClient);
                }
                throw throwable;
            }
            OpenSearchUtil.clearScroll((String)scrollId, (OpenSearchClient)this.zeebeOsClient);
        }
        return hitArray;
    }

    @Override
    public ImportBatch readNextBatchByPositionAndPartition(long positionFrom, Long positionTo) throws NoSuchIndexException {
        String aliasName = this.importValueType.getAliasName(this.tasklistProperties.getZeebeOpenSearch().getPrefix());
        try {
            SearchRequest searchRequest = this.createSearchQuery(aliasName, positionFrom, positionTo);
            SearchResponse searchResponse = this.withTimer(() -> this.zeebeOsClient.search(searchRequest, Object.class));
            return this.createImportBatch(searchResponse);
        }
        catch (OpenSearchException ex) {
            if (ex.getMessage().contains("no such index")) {
                LOGGER.warn("No index found for alias '{}'", (Object)aliasName);
                throw new NoSuchIndexException();
            }
            String message = String.format("Exception occurred for alias [%s], while obtaining next Zeebe records batch: %s", aliasName, ex.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)ex);
        }
        catch (Exception e) {
            String message = String.format("Exception occurred for alias [%s], while obtaining next Zeebe records batch: %s", aliasName, e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public ImportBatch readNextBatchBySequence(Long fromSequence, Long toSequence) throws NoSuchIndexException {
        long lessThanEqualsSequence;
        int maxNumberOfHits;
        String aliasName = this.importValueType.getAliasName(this.tasklistProperties.getZeebeOpenSearch().getPrefix());
        int batchSize = this.tasklistProperties.getZeebeOpenSearch().getBatchSize();
        if (toSequence != null && toSequence > 0L) {
            maxNumberOfHits = (int)((toSequence - fromSequence) * 2L);
            lessThanEqualsSequence = toSequence;
            LOGGER.debug("Import batch reread was called. Data type {}, partitionId {}, sequence {}, lastSequence {}, maxNumberOfHits {}.", new Object[]{this.importValueType, this.partitionId, fromSequence, toSequence, maxNumberOfHits});
        } else {
            maxNumberOfHits = batchSize;
            if (this.countEmptyRuns == this.tasklistProperties.getImporter().getMaxEmptyRuns()) {
                lessThanEqualsSequence = this.maxPossibleSequence;
                this.countEmptyRuns = 0;
                LOGGER.debug("Max empty runs reached. Data type {}, partitionId {}, sequence {}, lastSequence {}, maxNumberOfHits {}.", new Object[]{this.importValueType, this.partitionId, fromSequence, lessThanEqualsSequence, maxNumberOfHits});
            } else {
                lessThanEqualsSequence = fromSequence + (long)batchSize;
            }
        }
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().sort(s -> s.field(FieldSort.of(f -> f.field("sequence").order(SortOrder.Asc)))).query(q -> q.range(range -> range.field("sequence").gt(JsonData.of((Object)fromSequence)).lte(JsonData.of((Object)lessThanEqualsSequence)))).size(Integer.valueOf(maxNumberOfHits >= 10000 ? 10000 : maxNumberOfHits)).routing(String.valueOf(this.partitionId)).requestCache(Boolean.valueOf(false)).index(aliasName, new String[0]);
        try {
            Hit[] hits = this.withTimerSearchHits(() -> this.read(searchRequest, maxNumberOfHits >= 10000));
            this.countEmptyRuns = hits.length == 0 ? ++this.countEmptyRuns : 0;
            return this.createImportBatch(hits);
        }
        catch (OpenSearchException ex) {
            if (ex.getMessage().contains("no such index")) {
                throw new NoSuchIndexException();
            }
            String message = String.format("Exception occurred, while obtaining next Zeebe records batch: %s", ex.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)ex);
        }
        catch (Exception e) {
            String message = String.format("Exception occurred, while obtaining next Zeebe records batch: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    private SearchResponse withTimer(Callable<SearchResponse> callable) throws Exception {
        return (SearchResponse)this.metrics.getTimer("tasklist.import.query", new String[0]).recordCallable(callable);
    }

    private SearchRequest createSearchQuery(String aliasName, Long positionFrom, Long positionTo) {
        RangeQuery.Builder rangeQuery = new RangeQuery.Builder();
        rangeQuery.field("position").gt(JsonData.of((Object)positionFrom));
        if (positionTo != null) {
            rangeQuery.lte(JsonData.of((Object)positionTo));
        }
        Query query = OpenSearchUtil.joinWithAnd((ObjectBuilder[])new ObjectBuilder[]{new Query.Builder().range(rangeQuery.build()), new Query.Builder().term(term -> term.field("partitionId").value(FieldValue.of((long)this.partitionId)))});
        SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder();
        searchRequestBuilder.query(query).index(aliasName, new String[0]).sort(s -> s.field(f -> f.field("position").order(SortOrder.Asc)));
        if (positionTo == null) {
            searchRequestBuilder.size(Integer.valueOf(this.tasklistProperties.getZeebeOpenSearch().getBatchSize()));
        } else {
            LOGGER.debug("Import batch reread was called. Data type {}, partitionId {}, positionFrom {}, positionTo {}.", new Object[]{this.importValueType, this.partitionId, positionFrom, positionTo});
            int size = (int)(positionTo - positionFrom);
            searchRequestBuilder.size(Integer.valueOf(size <= 0 || size > 10000 ? 10000 : size));
        }
        return searchRequestBuilder.routing(String.valueOf(this.partitionId)).requestCache(Boolean.valueOf(false)).build();
    }
}

