/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.os;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.meta.ImportPositionEntity;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.ImportJobAbstract;
import io.camunda.tasklist.zeebeimport.os.ImportBatchOpenSearch;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Conditional(value={OpenSearchCondition.class})
public class ImportJobOpenSearch
extends ImportJobAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportJobOpenSearch.class);
    @Autowired
    @Qualifier(value="tasklistZeebeOsClient")
    private OpenSearchClient zeebeOsClient;

    public ImportJobOpenSearch(ImportBatch importBatch, ImportPositionEntity previousPosition) {
        this.importBatch = importBatch;
        this.previousPosition = previousPosition;
        this.creationTime = OffsetDateTime.now();
    }

    @Override
    public List<ImportBatch> createSubBatchesPerIndexName() {
        ArrayList<ImportBatch> subBatches = new ArrayList<ImportBatch>();
        if (this.importBatch.getHits().size() <= 1) {
            subBatches.add(this.importBatch);
            return subBatches;
        }
        String previousIndexName = null;
        ArrayList<Hit> subBatchHits = new ArrayList<Hit>();
        List importResult = this.importBatch.getHits();
        for (Hit hit : importResult) {
            String indexName = hit.index();
            if (previousIndexName != null && !indexName.equals(previousIndexName)) {
                subBatches.add((ImportBatch)new ImportBatchOpenSearch(this.importBatch.getPartitionId(), this.importBatch.getImportValueType(), subBatchHits, previousIndexName));
                subBatchHits = new ArrayList();
            }
            subBatchHits.add(hit);
            previousIndexName = indexName;
        }
        subBatches.add((ImportBatch)new ImportBatchOpenSearch(this.importBatch.getPartitionId(), this.importBatch.getImportValueType(), subBatchHits, previousIndexName));
        return subBatches;
    }

    @Override
    public void refreshZeebeIndices() {
        String indexPattern = this.importBatch.getImportValueType().getIndicesPattern(this.tasklistProperties.getZeebeElasticsearch().getPrefix());
        OpenSearchUtil.refreshIndicesFor((OpenSearchClient)this.zeebeOsClient, (String)indexPattern);
    }
}

