/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.meta.ImportPositionEntity;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.zeebeimport.ImportPositionHolder;
import io.camunda.tasklist.zeebeimport.ImportPositionHolderAbstract;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"tasklistSchemaStartup"})
@Conditional(value={ElasticSearchCondition.class})
public class ImportPositionHolderElasticSearch
extends ImportPositionHolderAbstract
implements ImportPositionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportPositionHolderElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;

    @Override
    public ImportPositionEntity getLatestLoadedPosition(String aliasTemplate, int partitionId) throws IOException {
        QueryBuilder queryBuilder = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"aliasName", (String)aliasTemplate), QueryBuilders.termQuery((String)"partitionId", (int)partitionId)});
        SearchRequest searchRequest = new SearchRequest(new String[]{this.importPositionType.getAlias()}).source(new SearchSourceBuilder().query(queryBuilder).size(10));
        SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
        Iterator hitIterator = searchResponse.getHits().iterator();
        ImportPositionEntity position = new ImportPositionEntity().setAliasName(aliasTemplate).setPartitionId(partitionId);
        if (hitIterator.hasNext()) {
            position = (ImportPositionEntity)ElasticsearchUtil.fromSearchHit((String)((SearchHit)hitIterator.next()).getSourceAsString(), (ObjectMapper)this.objectMapper, ImportPositionEntity.class);
        }
        LOGGER.debug("Latest loaded position for alias [{}] and partitionId [{}]: {}", new Object[]{aliasTemplate, partitionId, position});
        return position;
    }

    @Override
    public Either<Throwable, Boolean> updateImportPositions(Map<String, ImportPositionEntity> positions) {
        Either<Exception, BulkRequest> preparedBulkRequest = this.prepareBulkRequest(positions);
        if (preparedBulkRequest.isLeft()) {
            Exception e = (Exception)preparedBulkRequest.getLeft();
            return Either.left((Object)e);
        }
        try {
            BulkRequest bulkRequest = (BulkRequest)preparedBulkRequest.get();
            this.withImportPositionTimer(() -> {
                ElasticsearchUtil.processBulkRequest((RestHighLevelClient)this.esClient, (BulkRequest)bulkRequest);
                return null;
            });
            return Either.right((Object)true);
        }
        catch (Throwable e) {
            LOGGER.error("Error occurred while persisting latest loaded position", e);
            return Either.left((Object)e);
        }
    }

    private Either<Exception, UpdateRequest> prepareUpdateRequest(ImportPositionEntity position) {
        try {
            String index = this.importPositionType.getFullQualifiedName();
            String source = this.objectMapper.writeValueAsString((Object)position);
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("position", position.getPosition());
            updateFields.put("indexName", position.getIndexName());
            updateFields.put("sequence", position.getSequence());
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(position.getId()).upsert(source, XContentType.JSON).doc(updateFields);
            return Either.right((Object)updateRequest);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error occurred while preparing request to update processed position for %s", position.getAliasName()), (Throwable)e);
            return Either.left((Object)e);
        }
    }

    private Either<Exception, BulkRequest> prepareBulkRequest(Map<String, ImportPositionEntity> positions) {
        BulkRequest bulkRequest = new BulkRequest();
        if (positions.size() > 0) {
            Either preparedUpdateRequests = (Either)positions.values().stream().map(this::prepareUpdateRequest).collect(Either.collectorFoldingLeft());
            if (preparedUpdateRequests.isLeft()) {
                Exception e = (Exception)preparedUpdateRequests.getLeft();
                return Either.left((Object)e);
            }
            ((List)preparedUpdateRequests.get()).forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
        }
        return Either.right((Object)bulkRequest);
    }
}

