/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport;

import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.zeebeimport.RecordsReader;
import io.camunda.tasklist.zeebeimport.RecordsReaderHolder;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
@Configuration
@DependsOn(value={"tasklistSchemaStartup"})
public class ZeebeImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeImporter.class);
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private RecordsReaderHolder recordsReaderHolder;
    @Autowired
    @Qualifier(value="tasklistRecordsReaderThreadPoolExecutor")
    private ThreadPoolTaskScheduler readersExecutor;

    @PostConstruct
    public void startImportingData() {
        if (this.tasklistProperties.getImporter().isStartLoadingDataOnStartup()) {
            this.scheduleReaders();
        }
    }

    public void scheduleReaders() {
        Set<RecordsReader> allRecordsReaders = this.recordsReaderHolder.getAllRecordsReaders();
        LOGGER.info("INIT: Start importing data by '{}' importers", (Object)allRecordsReaders.size());
        allRecordsReaders.forEach(recordsReader -> this.readersExecutor.submit((Runnable)recordsReader));
    }

    public int performOneRoundOfImportFor(Collection<RecordsReader> readers) {
        int countRecords = 0;
        for (RecordsReader recordsReaderElasticSearch : readers) {
            countRecords += this.importOneBatch(recordsReaderElasticSearch, false);
        }
        return countRecords;
    }

    public int performOneRoundOfImport() {
        return this.performOneRoundOfImportFor(this.recordsReaderHolder.getAllRecordsReaders());
    }

    public int importOneBatch(RecordsReader recordsReader, boolean autoContinue) {
        return recordsReader.readAndScheduleNextBatch(autoContinue);
    }
}

