/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport;

import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.zeebe.ImportValueType;
import io.camunda.tasklist.zeebe.PartitionHolder;
import io.camunda.tasklist.zeebeimport.RecordsReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecordsReaderHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordsReaderHolder.class);
    private Set<RecordsReader> recordsReader = null;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private PartitionHolder partitionHolder;
    @Autowired
    private TasklistProperties tasklistProperties;

    public Set<RecordsReader> getAllRecordsReaders() {
        if (CollectionUtil.isNotEmpty(this.recordsReader)) {
            return this.recordsReader;
        }
        this.recordsReader = new HashSet<RecordsReader>();
        int queueSize = this.tasklistProperties.getImporter().getQueueSize();
        List partitionIds = this.partitionHolder.getPartitionIds();
        LOGGER.info("Starting import for partitions: {}", (Object)partitionIds);
        for (Integer partitionId : partitionIds) {
            for (ImportValueType importValueType : ImportValueType.values()) {
                if (importValueType.equals((Object)ImportValueType.PROCESS) && !partitionId.equals(1)) continue;
                this.recordsReader.add((RecordsReader)this.beanFactory.getBean(RecordsReader.class, new Object[]{partitionId, importValueType, queueSize}));
            }
        }
        return this.recordsReader;
    }

    public RecordsReader getRecordsReader(int partitionId, ImportValueType importValueType) {
        for (RecordsReader record : this.recordsReader) {
            if (record.getPartitionId() != partitionId || !record.getImportValueType().equals((Object)importValueType)) continue;
            return record;
        }
        return null;
    }
}

