/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.v850.record.intent;

import io.camunda.zeebe.protocol.v850.record.ValueType;
import io.camunda.zeebe.protocol.v850.record.intent.AuthorizationIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ClockIntent;
import io.camunda.zeebe.protocol.v850.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.v850.record.intent.CompensationSubscriptionIntent;
import io.camunda.zeebe.protocol.v850.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.v850.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.v850.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.v850.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.v850.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.v850.record.intent.EscalationIntent;
import io.camunda.zeebe.protocol.v850.record.intent.FormIntent;
import io.camunda.zeebe.protocol.v850.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.v850.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.v850.record.intent.JobIntent;
import io.camunda.zeebe.protocol.v850.record.intent.MessageBatchIntent;
import io.camunda.zeebe.protocol.v850.record.intent.MessageCorrelationIntent;
import io.camunda.zeebe.protocol.v850.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.v850.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.v850.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessEventIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceBatchIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceResultIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.v850.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.protocol.v850.record.intent.SignalIntent;
import io.camunda.zeebe.protocol.v850.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.v850.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.v850.record.intent.UserIntent;
import io.camunda.zeebe.protocol.v850.record.intent.UserTaskIntent;
import io.camunda.zeebe.protocol.v850.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.v850.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.v850.record.intent.management.CheckpointIntent;
import java.util.Arrays;
import java.util.Collection;

public interface Intent {
    public static final Collection<Class<? extends Intent>> INTENT_CLASSES = Arrays.asList(DeploymentIntent.class, EscalationIntent.class, IncidentIntent.class, JobIntent.class, ProcessInstanceIntent.class, MessageIntent.class, MessageBatchIntent.class, MessageSubscriptionIntent.class, ProcessMessageSubscriptionIntent.class, JobBatchIntent.class, TimerIntent.class, VariableIntent.class, VariableDocumentIntent.class, ProcessInstanceCreationIntent.class, ErrorIntent.class, ProcessIntent.class, DeploymentDistributionIntent.class, ProcessEventIntent.class, DecisionIntent.class, DecisionRequirementsIntent.class, DecisionEvaluationIntent.class, MessageStartEventSubscriptionIntent.class, ProcessInstanceResultIntent.class, CheckpointIntent.class, ProcessInstanceModificationIntent.class, SignalIntent.class, SignalSubscriptionIntent.class, ResourceDeletionIntent.class, CommandDistributionIntent.class, ProcessInstanceBatchIntent.class, FormIntent.class, UserTaskIntent.class, ProcessInstanceMigrationIntent.class, CompensationSubscriptionIntent.class, MessageCorrelationIntent.class, UserIntent.class, ClockIntent.class, AuthorizationIntent.class);
    public static final short NULL_VAL = 255;
    public static final Intent UNKNOWN = UnknownIntent.UNKNOWN;

    public short value();

    public String name();

    public boolean isEvent();

    public static Intent fromProtocolValue(ValueType valueType, short intent) {
        switch (valueType) {
            case DEPLOYMENT: {
                return DeploymentIntent.from(intent);
            }
            case INCIDENT: {
                return IncidentIntent.from(intent);
            }
            case JOB: {
                return JobIntent.from(intent);
            }
            case PROCESS_INSTANCE: {
                return ProcessInstanceIntent.from(intent);
            }
            case MESSAGE: {
                return MessageIntent.from(intent);
            }
            case MESSAGE_BATCH: {
                return MessageBatchIntent.from(intent);
            }
            case MESSAGE_SUBSCRIPTION: {
                return MessageSubscriptionIntent.from(intent);
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return MessageStartEventSubscriptionIntent.from(intent);
            }
            case PROCESS_MESSAGE_SUBSCRIPTION: {
                return ProcessMessageSubscriptionIntent.from(intent);
            }
            case JOB_BATCH: {
                return JobBatchIntent.from(intent);
            }
            case TIMER: {
                return TimerIntent.from(intent);
            }
            case VARIABLE: {
                return VariableIntent.from(intent);
            }
            case VARIABLE_DOCUMENT: {
                return VariableDocumentIntent.from(intent);
            }
            case PROCESS_INSTANCE_CREATION: {
                return ProcessInstanceCreationIntent.from(intent);
            }
            case ERROR: {
                return ErrorIntent.from(intent);
            }
            case PROCESS_INSTANCE_RESULT: {
                return ProcessInstanceResultIntent.from(intent);
            }
            case PROCESS: {
                return ProcessIntent.from(intent);
            }
            case DEPLOYMENT_DISTRIBUTION: {
                return DeploymentDistributionIntent.from(intent);
            }
            case PROCESS_EVENT: {
                return ProcessEventIntent.from(intent);
            }
            case DECISION: {
                return DecisionIntent.from(intent);
            }
            case DECISION_REQUIREMENTS: {
                return DecisionRequirementsIntent.from(intent);
            }
            case DECISION_EVALUATION: {
                return DecisionEvaluationIntent.from(intent);
            }
            case CHECKPOINT: {
                return CheckpointIntent.from(intent);
            }
            case ESCALATION: {
                return EscalationIntent.from(intent);
            }
            case PROCESS_INSTANCE_MODIFICATION: {
                return ProcessInstanceModificationIntent.from(intent);
            }
            case SIGNAL: {
                return SignalIntent.from(intent);
            }
            case SIGNAL_SUBSCRIPTION: {
                return SignalSubscriptionIntent.from(intent);
            }
            case RESOURCE_DELETION: {
                return ResourceDeletionIntent.from(intent);
            }
            case COMMAND_DISTRIBUTION: {
                return CommandDistributionIntent.from(intent);
            }
            case PROCESS_INSTANCE_BATCH: {
                return ProcessInstanceBatchIntent.from(intent);
            }
            case FORM: {
                return FormIntent.from(intent);
            }
            case USER_TASK: {
                return UserTaskIntent.from(intent);
            }
            case PROCESS_INSTANCE_MIGRATION: {
                return ProcessInstanceMigrationIntent.from(intent);
            }
            case COMPENSATION_SUBSCRIPTION: {
                return CompensationSubscriptionIntent.from(intent);
            }
            case MESSAGE_CORRELATION: {
                return MessageCorrelationIntent.from(intent);
            }
            case USER: {
                return UserIntent.from(intent);
            }
            case CLOCK: {
                return ClockIntent.from(intent);
            }
            case AUTHORIZATION: {
                return AuthorizationIntent.from(intent);
            }
            case NULL_VAL: 
            case SBE_UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new RuntimeException(String.format("Expected to map value type %s to intent type, but did not recognize the value type", valueType.name()));
    }

    public static Intent fromProtocolValue(ValueType valueType, String intent) {
        switch (valueType) {
            case DEPLOYMENT: {
                return DeploymentIntent.valueOf(intent);
            }
            case INCIDENT: {
                return IncidentIntent.valueOf(intent);
            }
            case JOB: {
                return JobIntent.valueOf(intent);
            }
            case PROCESS_INSTANCE: {
                return ProcessInstanceIntent.valueOf(intent);
            }
            case MESSAGE: {
                return MessageIntent.valueOf(intent);
            }
            case MESSAGE_BATCH: {
                return MessageBatchIntent.valueOf(intent);
            }
            case MESSAGE_SUBSCRIPTION: {
                return MessageSubscriptionIntent.valueOf(intent);
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return MessageStartEventSubscriptionIntent.valueOf(intent);
            }
            case PROCESS_MESSAGE_SUBSCRIPTION: {
                return ProcessMessageSubscriptionIntent.valueOf(intent);
            }
            case JOB_BATCH: {
                return JobBatchIntent.valueOf(intent);
            }
            case TIMER: {
                return TimerIntent.valueOf(intent);
            }
            case VARIABLE: {
                return VariableIntent.valueOf(intent);
            }
            case VARIABLE_DOCUMENT: {
                return VariableDocumentIntent.valueOf(intent);
            }
            case PROCESS_INSTANCE_CREATION: {
                return ProcessInstanceCreationIntent.valueOf(intent);
            }
            case ERROR: {
                return ErrorIntent.valueOf(intent);
            }
            case PROCESS_INSTANCE_RESULT: {
                return ProcessInstanceResultIntent.valueOf(intent);
            }
            case PROCESS: {
                return ProcessIntent.valueOf(intent);
            }
            case DEPLOYMENT_DISTRIBUTION: {
                return DeploymentDistributionIntent.valueOf(intent);
            }
            case PROCESS_EVENT: {
                return ProcessEventIntent.valueOf(intent);
            }
            case DECISION: {
                return DecisionIntent.valueOf(intent);
            }
            case DECISION_REQUIREMENTS: {
                return DecisionRequirementsIntent.valueOf(intent);
            }
            case DECISION_EVALUATION: {
                return DecisionEvaluationIntent.valueOf(intent);
            }
            case CHECKPOINT: {
                return CheckpointIntent.valueOf(intent);
            }
            case ESCALATION: {
                return EscalationIntent.valueOf(intent);
            }
            case SIGNAL: {
                return SignalIntent.valueOf(intent);
            }
            case SIGNAL_SUBSCRIPTION: {
                return SignalSubscriptionIntent.valueOf(intent);
            }
            case RESOURCE_DELETION: {
                return ResourceDeletionIntent.valueOf(intent);
            }
            case FORM: {
                return FormIntent.valueOf(intent);
            }
            case USER_TASK: {
                return UserTaskIntent.valueOf(intent);
            }
            case PROCESS_INSTANCE_MIGRATION: {
                return ProcessInstanceMigrationIntent.valueOf(intent);
            }
            case COMPENSATION_SUBSCRIPTION: {
                return CompensationSubscriptionIntent.valueOf(intent);
            }
            case MESSAGE_CORRELATION: {
                return MessageCorrelationIntent.valueOf(intent);
            }
            case USER: {
                return UserIntent.valueOf(intent);
            }
            case CLOCK: {
                return ClockIntent.valueOf(intent);
            }
            case AUTHORIZATION: {
                return AuthorizationIntent.valueOf(intent);
            }
            case NULL_VAL: 
            case SBE_UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new RuntimeException(String.format("Expected to map value type %s to intent type, but did not recognize the value type", valueType.name()));
    }

    public static int maxCardinality() {
        return INTENT_CLASSES.stream().mapToInt(clazz -> ((Intent[])clazz.getEnumConstants()).length).max().getAsInt();
    }

    public static enum UnknownIntent implements Intent
    {
        UNKNOWN;


        @Override
        public short value() {
            return 255;
        }

        @Override
        public boolean isEvent() {
            return false;
        }
    }
}

