/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v850.processors.os;

import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.VariableEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.VariableIndex;
import io.camunda.tasklist.zeebeimport.v850.record.Intent;
import io.camunda.tasklist.zeebeimport.v850.record.value.VariableRecordValueImpl;
import io.camunda.zeebe.protocol.v850.record.Record;
import java.util.HashMap;
import java.util.List;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class VariableZeebeRecordProcessorOpenSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableZeebeRecordProcessorOpenSearch.class);
    @Autowired
    private VariableIndex variableIndex;
    @Autowired
    private TasklistProperties tasklistProperties;

    public void processVariableRecord(Record record, List<BulkOperation> operations) throws PersistenceException {
        VariableRecordValueImpl recordValue = (VariableRecordValueImpl)record.getValue();
        if (record.getIntent().name() != Intent.MIGRATED.name()) {
            operations.add(this.persistVariable(record, recordValue));
        }
    }

    private BulkOperation persistVariable(Record record, VariableRecordValueImpl recordValue) throws PersistenceException {
        VariableEntity entity = new VariableEntity();
        entity.setId(VariableEntity.getIdBy((String)String.valueOf(recordValue.getScopeKey()), (String)recordValue.getName()));
        entity.setKey(record.getKey());
        entity.setPartitionId(record.getPartitionId());
        entity.setScopeFlowNodeId(String.valueOf(recordValue.getScopeKey()));
        entity.setProcessInstanceId(String.valueOf(recordValue.getProcessInstanceKey()));
        entity.setName(recordValue.getName());
        entity.setTenantId(recordValue.getTenantId());
        if (recordValue.getValue().length() > this.tasklistProperties.getImporter().getVariableSizeThreshold()) {
            entity.setValue(recordValue.getValue().substring(0, this.tasklistProperties.getImporter().getVariableSizeThreshold()));
            entity.setIsPreview(true);
        } else {
            entity.setValue(recordValue.getValue());
        }
        entity.setFullValue(recordValue.getValue());
        return this.getVariableQuery(entity);
    }

    private BulkOperation getVariableQuery(VariableEntity entity) throws PersistenceException {
        LOGGER.debug("Variable instance for list view: id {}", (Object)entity.getId());
        HashMap<String, Object> updateFields = new HashMap<String, Object>();
        updateFields.put("value", entity.getValue());
        updateFields.put("fullValue", entity.getFullValue());
        updateFields.put("isPreview", entity.getIsPreview());
        return (BulkOperation)new BulkOperation.Builder().update(up -> ((UpdateOperation.Builder)((UpdateOperation.Builder)up.index(this.variableIndex.getFullQualifiedName())).id(entity.getId())).document((Object)CommonUtils.getJsonObjectFromEntity((Object)entity)).docAsUpsert(Boolean.valueOf(true)).retryOnConflict(Integer.valueOf(3))).build();
    }
}

