/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v850.processors.os;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.camunda.tasklist.zeebe.ImportValueType;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.os.AbstractImportBatchProcessorOpenSearch;
import io.camunda.tasklist.zeebeimport.v850.processors.os.FormZeebeRecordProcessorOpenSearch;
import io.camunda.tasklist.zeebeimport.v850.processors.os.JobZeebeRecordProcessorOpenSearch;
import io.camunda.tasklist.zeebeimport.v850.processors.os.ProcessInstanceZeebeRecordProcessorOpenSearch;
import io.camunda.tasklist.zeebeimport.v850.processors.os.ProcessZeebeRecordProcessorOpenSearch;
import io.camunda.tasklist.zeebeimport.v850.processors.os.UserTaskZeebeRecordProcessorOpenSearch;
import io.camunda.tasklist.zeebeimport.v850.processors.os.VariableZeebeRecordProcessorOpenSearch;
import io.camunda.tasklist.zeebeimport.v850.record.RecordImpl;
import io.camunda.tasklist.zeebeimport.v850.record.value.JobRecordValueImpl;
import io.camunda.tasklist.zeebeimport.v850.record.value.ProcessInstanceRecordValueImpl;
import io.camunda.tasklist.zeebeimport.v850.record.value.UserTaskRecordValueImpl;
import io.camunda.tasklist.zeebeimport.v850.record.value.VariableRecordValueImpl;
import io.camunda.tasklist.zeebeimport.v850.record.value.deployment.DeployedProcessImpl;
import io.camunda.tasklist.zeebeimport.v850.record.value.deployment.FormRecordImpl;
import io.camunda.zeebe.protocol.v850.record.Record;
import io.camunda.zeebe.protocol.v850.record.RecordValue;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class OpenSearchBulkProcessor
extends AbstractImportBatchProcessorOpenSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchBulkProcessor.class);
    @Autowired
    private ProcessInstanceZeebeRecordProcessorOpenSearch processInstanceZeebeRecordProcessor;
    @Autowired
    private VariableZeebeRecordProcessorOpenSearch variableZeebeRecordProcessor;
    @Autowired
    private JobZeebeRecordProcessorOpenSearch jobZeebeRecordProcessor;
    @Autowired
    private ProcessZeebeRecordProcessorOpenSearch processZeebeRecordProcessor;
    @Autowired
    private FormZeebeRecordProcessorOpenSearch formZeebeRecordProcessor;
    @Autowired
    private UserTaskZeebeRecordProcessorOpenSearch userTaskZeebeRecordProcessor;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private Metrics metrics;

    protected void processZeebeRecords(ImportBatch importBatch, List<BulkOperation> operations) throws PersistenceException {
        JavaType valueType = this.objectMapper.getTypeFactory().constructParametricType(RecordImpl.class, new Class[]{this.getRecordValueClass(importBatch.getImportValueType())});
        List zeebeRecords = OpenSearchUtil.mapSearchHits((List)importBatch.getHits(), (ObjectMapper)this.objectMapper, (JavaType)valueType);
        ImportValueType importValueType = importBatch.getImportValueType();
        LOGGER.debug("Writing [{}] Zeebe records to OpenSearch", (Object)zeebeRecords.size());
        block8: for (Record record : zeebeRecords) {
            switch (importValueType) {
                case PROCESS_INSTANCE: {
                    this.processInstanceZeebeRecordProcessor.processProcessInstanceRecord(record, operations);
                    continue block8;
                }
                case VARIABLE: {
                    this.variableZeebeRecordProcessor.processVariableRecord(record, operations);
                    continue block8;
                }
                case JOB: {
                    this.jobZeebeRecordProcessor.processJobRecord(record, operations);
                    continue block8;
                }
                case PROCESS: {
                    this.processZeebeRecordProcessor.processDeploymentRecord(record, operations);
                    continue block8;
                }
                case FORM: {
                    this.formZeebeRecordProcessor.processFormRecord(record, operations);
                    continue block8;
                }
                case USER_TASK: {
                    this.userTaskZeebeRecordProcessor.processUserTaskRecord(record, operations);
                    continue block8;
                }
            }
            LOGGER.debug("Default case triggered for type {}", (Object)importValueType);
        }
        this.recordRecordImportTime(zeebeRecords);
    }

    private void recordRecordImportTime(List<Record> zeebeRecords) {
        long currentTime = OffsetDateTime.now().toInstant().toEpochMilli();
        zeebeRecords.forEach(record -> this.metrics.getTimer("tasklist.import.time", new String[]{"type", record.getValueType().toString(), "partition", String.valueOf(record.getPartitionId())}).record(currentTime - record.getTimestamp(), TimeUnit.MILLISECONDS));
    }

    protected Class<? extends RecordValue> getRecordValueClass(ImportValueType importValueType) {
        switch (importValueType) {
            case PROCESS_INSTANCE: {
                return ProcessInstanceRecordValueImpl.class;
            }
            case JOB: {
                return JobRecordValueImpl.class;
            }
            case VARIABLE: {
                return VariableRecordValueImpl.class;
            }
            case PROCESS: {
                return DeployedProcessImpl.class;
            }
            case FORM: {
                return FormRecordImpl.class;
            }
            case USER_TASK: {
                return UserTaskRecordValueImpl.class;
            }
        }
        throw new TasklistRuntimeException(String.format("No value type class found for: %s", importValueType));
    }

    public String getZeebeVersion() {
        return "8.5";
    }
}

